/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.client.display;

import com.creativemd.creativecore.client.CreativeCoreClient;
import com.creativemd.creativecore.common.utils.math.vec.Vec;
import com.creativemd.creativecore.common.utils.math.vec.Vec3;
import com.github.kiulian.downloader.YoutubeDownloader;
import com.github.kiulian.downloader.downloader.request.RequestVideoInfo;
import com.github.kiulian.downloader.model.videos.VideoDetails;
import com.github.kiulian.downloader.model.videos.VideoInfo;
import com.github.kiulian.downloader.model.videos.formats.AudioFormat;
import com.github.kiulian.downloader.model.videos.formats.VideoFormat;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.compress.utils.IOUtils;
import org.lwjgl.opengl.GL11;
import team.creative.littleframes.client.display.FrameDisplay;
import team.creative.littleframes.client.display.StreamQuality;
import team.creative.littleframes.client.texture.TextureCache;
import team.creative.littleframes.client.vlc.VLCDiscovery;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.component.CallbackMediaPlayerComponent;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormat;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormatCallback;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.RenderCallback;

public class FrameVideoDisplay
extends FrameDisplay {
    private static final String VLC_DOWNLOAD_32 = "https://i.imgur.com/qDIb9iV.png";
    private static final String VLC_DOWNLOAD_64 = "https://i.imgur.com/3EKo7Jx.png";
    private static final int ACCEPTABLE_SYNC_TIME = 2000;
    private static final List<FrameVideoDisplay> OPEN_DISPLAYS = new ArrayList<FrameVideoDisplay>();
    private static final Pattern PATTERN = Pattern.compile("(?:youtu\\.be/|youtube\\.com/(?:embed/|v/|shorts/|feeds/api/videos/|watch\\?v=|watch\\?.+&v=))([^/?&#]+)");
    public volatile int width = 1;
    public volatile int height = 1;
    public volatile CallbackMediaPlayerComponent player;
    private final Vec3 pos;
    public volatile ByteBuffer buffer;
    public int texture;
    private boolean stream = false;
    private volatile float lastSetVolume;
    private volatile boolean needsUpdate = false;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile boolean first = true;
    private long lastCorrectedTime = Long.MIN_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick() {
        List<FrameVideoDisplay> list = OPEN_DISPLAYS;
        synchronized (list) {
            for (FrameVideoDisplay display : OPEN_DISPLAYS) {
                if (!Minecraft.func_71410_x().func_147113_T()) continue;
                if (display.stream) {
                    if (!display.player.mediaPlayer().status().isPlaying()) continue;
                    display.player.mediaPlayer().controls().setPause(true);
                    continue;
                }
                if (display.player.mediaPlayer().status().length() <= 0L || !display.player.mediaPlayer().status().isPlaying()) continue;
                display.player.mediaPlayer().controls().setPause(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unload() {
        List<FrameVideoDisplay> list = OPEN_DISPLAYS;
        synchronized (list) {
            for (FrameVideoDisplay display : OPEN_DISPLAYS) {
                display.free();
            }
            OPEN_DISPLAYS.clear();
        }
    }

    public static FrameDisplay createVideoDisplay(Vec3 pos, String url, float volume, float minDistance, float maxDistance, boolean loop) {
        if (VLCDiscovery.isLoadedOrRequest()) {
            if (VLCDiscovery.isAvailable()) {
                FrameVideoDisplay display = new FrameVideoDisplay(pos, url, volume, minDistance, maxDistance, loop);
                OPEN_DISPLAYS.add(display);
                return display;
            }
        } else {
            return null;
        }
        String failURL = System.getProperty("sun.arch.data.model").equals("32") ? VLC_DOWNLOAD_32 : VLC_DOWNLOAD_64;
        TextureCache cache = TextureCache.get(failURL);
        if (cache.ready()) {
            return cache.createDisplay(pos, failURL, volume, minDistance, maxDistance, loop, true);
        }
        return null;
    }

    private String fetchLivePlaylist(String url) throws IOException {
        URL apiUrl = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)apiUrl.openConnection();
        conn.setRequestMethod("GET");
        int responseCode = conn.getResponseCode();
        if (responseCode != 200) {
            return null;
        }
        byte[] bytes = IOUtils.toByteArray((InputStream)conn.getInputStream());
        return new String(bytes);
    }

    public String patch(String videoId) {
        try {
            VideoInfo videoInfo = new YoutubeDownloader().getVideoInfo(new RequestVideoInfo(videoId)).data();
            VideoDetails videoDetails = videoInfo.details();
            if (videoDetails.isLive()) {
                String ytLivePlaylist = this.fetchLivePlaylist(videoDetails.liveUrl());
                if (ytLivePlaylist != null) {
                    return StreamQuality.parse(ytLivePlaylist).get(0).getUrl();
                }
            } else {
                VideoFormat bestWithAudio = videoInfo.bestVideoWithAudioFormat();
                if (bestWithAudio != null) {
                    return bestWithAudio.url();
                }
                VideoFormat bestWithoutAudio = videoInfo.bestVideoFormat();
                if (bestWithoutAudio != null) {
                    return bestWithoutAudio.url();
                }
                AudioFormat bestWithoutVideo = videoInfo.bestAudioFormat();
                if (bestWithoutVideo != null) {
                    return bestWithoutVideo.url();
                }
            }
            return "https://www.youtube.com/watch?v=" + videoId;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public FrameVideoDisplay(Vec3 pos, String url, float volume, float minDistance, float maxDistance, boolean loop) {
        this.texture = GlStateManager.func_179146_y();
        this.pos = pos;
        this.player = new CallbackMediaPlayerComponent(VLCDiscovery.factory, null, null, false, new RenderCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void display(MediaPlayer mediaPlayer, ByteBuffer[] nativeBuffers, BufferFormat bufferFormat) {
                FrameVideoDisplay.this.lock.lock();
                try {
                    nativeBuffers[0].rewind();
                    FrameVideoDisplay.this.buffer.put(nativeBuffers[0]);
                    FrameVideoDisplay.this.buffer.rewind();
                    FrameVideoDisplay.this.needsUpdate = true;
                }
                finally {
                    FrameVideoDisplay.this.lock.unlock();
                }
            }
        }, new BufferFormatCallback(){

            @Override
            public BufferFormat getBufferFormat(int sourceWidth, int sourceHeight) {
                FrameVideoDisplay.this.lock.lock();
                try {
                    FrameVideoDisplay.this.width = sourceWidth;
                    FrameVideoDisplay.this.height = sourceHeight;
                    FrameVideoDisplay.this.first = true;
                    FrameVideoDisplay.this.buffer = ByteBuffer.allocateDirect(sourceWidth * sourceHeight * 4);
                    FrameVideoDisplay.this.needsUpdate = true;
                }
                finally {
                    FrameVideoDisplay.this.lock.unlock();
                }
                return new BufferFormat("RGBA", sourceWidth, sourceHeight, new int[]{sourceWidth * 4}, new int[]{sourceHeight});
            }

            @Override
            public void allocatedBuffers(ByteBuffer[] buffers) {
            }
        }, null);
        float tempVolume = this.getVolume(volume, minDistance, maxDistance);
        this.player.mediaPlayer().audio().setVolume((int)tempVolume);
        this.lastSetVolume = tempVolume;
        this.player.mediaPlayer().controls().setRepeat(loop);
        String[] finalUrl = new String[]{url};
        Thread thread = new Thread(() -> {
            Matcher matcher = PATTERN.matcher(finalUrl[0]);
            if (matcher.find()) {
                finalUrl[0] = this.patch(matcher.group(1));
            }
            this.player.mediaPlayer().media().start(finalUrl[0], new String[0]);
        });
        thread.setName("VLC/start");
        thread.setDaemon(true);
        thread.start();
    }

    public static boolean isValidURL(String urlString) {
        try {
            URL url = new URL(urlString);
            url.toURI();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getVolume(float volume, float minDistance, float maxDistance) {
        if (this.player == null) {
            return 0;
        }
        if (minDistance > maxDistance) {
            float temp = maxDistance;
            maxDistance = minDistance;
            minDistance = temp;
        }
        if (this.distance() > minDistance) {
            volume = this.distance() > maxDistance ? (volume *= 1.0f - (this.distance() - minDistance) / (maxDistance - minDistance)) : (volume *= 1.0f - (this.distance() - minDistance) / (maxDistance - minDistance));
        }
        return (int)(volume * 100.0f);
    }

    public float distance() {
        Vec3d playerpos = Minecraft.func_71410_x().field_71439_g.func_174791_d();
        return (float)this.pos.distance((Vec)new Vec3(playerpos.field_72450_a, playerpos.field_72448_b, playerpos.field_72449_c));
    }

    @Override
    public void tick(String url, float volume, float minDistance, float maxDistance, boolean playing, boolean loop, int tick) {
        if (this.player == null) {
            return;
        }
        if (this.player != null && this.player.mediaPlayer().media().isValid()) {
            boolean realPlaying;
            if ((volume = (float)this.getVolume(volume, minDistance, maxDistance)) != this.lastSetVolume) {
                this.player.mediaPlayer().audio().setVolume((int)volume);
                this.lastSetVolume = volume;
            }
            boolean bl = realPlaying = playing && !Minecraft.func_71410_x().func_147113_T();
            if ((float)Math.round(this.distance()) > maxDistance) {
                realPlaying = false;
            }
            if (this.player.mediaPlayer().controls().getRepeat() != loop) {
                this.player.mediaPlayer().controls().setRepeat(loop);
            }
            long tickTime = 50L;
            long newDuration = this.player.mediaPlayer().status().length();
            if (!this.stream && newDuration == 0L && Objects.requireNonNull(this.player.mediaPlayer().media().info()).duration() == 0L) {
                this.stream = true;
            }
            if (this.stream) {
                if (this.player.mediaPlayer().status().isPlaying() != realPlaying) {
                    this.player.mediaPlayer().controls().setPause(!realPlaying);
                }
            } else if (this.player.mediaPlayer().status().length() > 0L) {
                if (this.player.mediaPlayer().status().isPlaying() != realPlaying) {
                    this.player.mediaPlayer().controls().setPause(!realPlaying);
                }
                if (this.player.mediaPlayer().status().isSeekable() && FrameVideoDisplay.isValidURL(url)) {
                    long time = (long)tick * tickTime + (realPlaying ? (long)(CreativeCoreClient.getRenderPartialTicks() * (float)tickTime) : 0L);
                    if (time > this.player.mediaPlayer().status().time() && loop && this.player.mediaPlayer().status().length() != 0L) {
                        time %= this.player.mediaPlayer().status().length();
                    }
                    if (Math.abs(time - this.player.mediaPlayer().status().time()) > 2000L && Math.abs(time - this.lastCorrectedTime) > 2000L) {
                        long ntime = (long)tick * tickTime + (realPlaying ? (long)(CreativeCoreClient.getRenderPartialTicks() * (float)tickTime) : 0L);
                        if (loop && this.player.mediaPlayer().status().length() != 0L) {
                            ntime %= this.player.mediaPlayer().status().length();
                        }
                        this.lastCorrectedTime = ntime;
                        if (this.player.mediaPlayer().status().time() + 2000L < this.player.mediaPlayer().status().length()) {
                            this.player.mediaPlayer().controls().setTime(ntime);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(String url, float volume, float minDistance, float maxDistance, boolean playing, boolean loop, int tick) {
        if (this.player == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.needsUpdate) {
                GlStateManager.func_187425_g((int)3314, (int)0);
                GlStateManager.func_187425_g((int)3316, (int)0);
                GlStateManager.func_187425_g((int)3315, (int)0);
                GlStateManager.func_179144_i((int)this.texture);
                if (this.first) {
                    GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5121, (ByteBuffer)this.buffer);
                    this.first = false;
                } else {
                    GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)this.width, (int)this.height, (int)6408, (int)5121, (ByteBuffer)this.buffer);
                }
                this.needsUpdate = false;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void free() {
        if (this.player != null) {
            CallbackMediaPlayerComponent tempPlayer = this.player;
            Thread thread = new Thread(() -> tempPlayer.mediaPlayer().release());
            thread.setName("VLC/start");
            thread.setDaemon(true);
            thread.start();
        }
        if (this.texture != -1) {
            Minecraft.func_71410_x().func_152344_a(() -> GlStateManager.func_179150_h((int)this.texture));
            this.texture = -1;
        }
        this.player = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.free();
        List<FrameVideoDisplay> list = OPEN_DISPLAYS;
        synchronized (list) {
            OPEN_DISPLAYS.remove(this);
        }
    }

    @Override
    public int texture() {
        return this.texture;
    }

    @Override
    public void pause(String url, float volume, float minDistance, float maxDistance, boolean playing, boolean loop, int tick) {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().controls().setTime((long)tick * 50L);
        this.player.mediaPlayer().controls().pause();
    }

    @Override
    public void prev(String url, float volume, float minDistance, float maxDistance, boolean playing, boolean loop, int tick) {
    }

    @Override
    public void next(String url, float volume, float minDistance, float maxDistance, boolean playing, boolean loop, int tick) {
    }

    @Override
    public void resume(String url, float volume, float minDistance, float maxDistance, boolean playing, boolean loop, int tick) {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().controls().setTime((long)tick * 50L);
        this.player.mediaPlayer().controls().play();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean canTick() {
        return this.player != null && this.player.mediaPlayer().status().isPlayable();
    }
}

