/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.client;

import com.creativemd.creativecore.common.utils.math.box.AlignedBox;
import com.creativemd.creativecore.common.utils.math.box.BoxCorner;
import com.creativemd.creativecore.common.utils.math.box.BoxFace;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.creative.littleframes.client.display.FrameDisplay;
import team.creative.littleframes.common.block.TileEntityCreativeFrame;

@SideOnly(value=Side.CLIENT)
public class CreativeFrameTileRenderer
extends TileEntitySpecialRenderer<TileEntityCreativeFrame> {
    public void render(TileEntityCreativeFrame frame, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (frame.isURLEmpty() || frame.alpha == 0.0f) {
            if (frame.display != null) {
                frame.display.release();
            }
            return;
        }
        FrameDisplay display = frame.requestDisplay();
        if (display == null) {
            return;
        }
        display.prepare(frame.getURL(), frame.volume, frame.minDistance, frame.maxDistance, frame.playing, frame.loop, frame.tick);
        GlStateManager.func_179147_l();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)frame.brightness, (float)frame.brightness, (float)frame.brightness, (float)frame.alpha);
        int texture = display.texture();
        GlStateManager.func_179144_i((int)texture);
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_187421_b((int)3553, (int)10241, (int)9728);
        GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        EnumFacing facing = EnumFacing.func_82600_a((int)frame.func_145832_p());
        AlignedBox box = frame.getBox();
        BoxFace face = BoxFace.get((EnumFacing)facing);
        GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.func_179114_b((float)(facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? -frame.rotation : frame.rotation), (float)(facing.func_176740_k() == EnumFacing.Axis.X ? 1.0f : 0.0f), (float)(facing.func_176740_k() == EnumFacing.Axis.Y ? 1.0f : 0.0f), (float)(facing.func_176740_k() == EnumFacing.Axis.Z ? 1.0f : 0.0f));
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
        GlStateManager.func_179091_B();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(9, DefaultVertexFormats.field_181707_g);
        for (BoxCorner corner : face.corners) {
            builder.func_181662_b((double)box.getValueOfFacing(corner.x), (double)box.getValueOfFacing(corner.y), (double)box.getValueOfFacing(corner.z)).func_187315_a(corner.isFacing(face.getTexU()) != frame.flipX ? 1.0 : 0.0, corner.isFacing(face.getTexV()) != frame.flipY ? 1.0 : 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        if (frame.bothSides) {
            GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
            builder.func_181668_a(9, DefaultVertexFormats.field_181707_g);
            for (BoxCorner corner : face.corners) {
                builder.func_181662_b((double)box.getValueOfFacing(corner.x), (double)box.getValueOfFacing(corner.y), (double)box.getValueOfFacing(corner.z)).func_187315_a(corner.isFacing(face.getTexU()) != frame.flipX ? 1.0 : 0.0, corner.isFacing(face.getTexV()) != frame.flipY ? 1.0 : 0.0).func_181675_d();
            }
            tessellator.func_78381_a();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
    }

    public boolean isGlobalRenderer(TileEntityCreativeFrame te) {
        return te.getSizeX() > 16.0f || te.getSizeY() > 16.0f;
    }
}

