/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes;

import com.creativemd.creativecore.common.config.holder.CreativeConfigRegistry;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.container.SubContainer;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.opener.CustomGuiHandler;
import com.creativemd.creativecore.common.gui.opener.GuiHandler;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.littletiles.client.gui.handler.LittleStructureGuiHandler;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.signal.logic.SignalMode;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructureBuilder;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import team.creative.littleframes.LittleFramesConfig;
import team.creative.littleframes.client.LittleFramesClient;
import team.creative.littleframes.client.display.FrameVideoDisplay;
import team.creative.littleframes.client.gui.SubGuiLittleFrame;
import team.creative.littleframes.common.block.BlockCreativeFrame;
import team.creative.littleframes.common.block.TileEntityCreativeFrame;
import team.creative.littleframes.common.container.SubContainerLittleFrame;
import team.creative.littleframes.common.packet.CreativeFramePacket;
import team.creative.littleframes.common.packet.LittleFramePacket;
import team.creative.littleframes.common.structure.LittleFrame;

@Mod(modid="littleframes", version="1.0.0", name="LittleFrames", acceptedMinecraftVersions="", dependencies="required-after:creativecore", guiFactory="team.creative.littleframes.LittleFramesSettings")
@Mod.EventBusSubscriber
public class LittleFrames {
    public static final String modid = "littleframes";
    public static final String version = "1.0.0";
    public static Block frame = (Block)new BlockCreativeFrame().func_149663_c("creative_frame").setRegistryName("creative_frame");
    public static Item remote_control;
    public static LittleFramesConfig CONFIG;

    @SideOnly(value=Side.CLIENT)
    public static void initClient() {
        LittleFramesClient.initClient();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) throws InstantiationException, IllegalAccessException {
        MinecraftForge.EVENT_BUS.register(LittleFrames.class);
    }

    @SubscribeEvent
    public static void worldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            FrameVideoDisplay.unload();
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{frame});
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new ItemBlock(frame).setRegistryName(Objects.requireNonNull(frame.getRegistryName()))});
        if (FMLCommonHandler.instance().getSide().isClient()) {
            LittleFrames.initClient();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        CONFIG = new LittleFramesConfig();
        CreativeConfigRegistry.ROOT.registerValue(modid, (Object)CONFIG);
        CreativeCorePacket.registerPacket(CreativeFramePacket.class);
        CreativeCorePacket.registerPacket(LittleFramePacket.class);
        GameRegistry.registerTileEntity(TileEntityCreativeFrame.class, (ResourceLocation)new ResourceLocation(modid, "CreativeFrame"));
        LittleStructureBuilder.register((LittleStructureBuilder.LittleStructureBuilderType)new LittleStructureBuilder.LittleStructureBuilderType(LittleStructureRegistry.registerStructureType((String)"little_frame", (String)"decoration", LittleFrame.class, (int)3072, null).addOutput("playframe", 1, SignalMode.TOGGLE, true), "frame"));
        GuiHandler.registerGuiHandler((String)"little_frame", (CustomGuiHandler)new LittleStructureGuiHandler(){

            @SideOnly(value=Side.CLIENT)
            public SubGui getGui(EntityPlayer player, NBTTagCompound nbt, LittleStructure structure) {
                if (structure instanceof LittleFrame) {
                    return new SubGuiLittleFrame((LittleFrame)structure);
                }
                return null;
            }

            public SubContainer getContainer(EntityPlayer player, NBTTagCompound nbt, LittleStructure structure) {
                if (structure instanceof LittleFrame) {
                    return new SubContainerLittleFrame(player, (LittleFrame)structure);
                }
                return null;
            }
        });
        LittleStructureRegistry.registerGuiParserNotFoundHandler((LittleStructureGuiParser.LittleStructureGuiParserNotFoundHandler)new LittleStructureGuiParser.LittleStructureGuiParserNotFoundHandler(){

            @SideOnly(value=Side.CLIENT)
            public LittleStructureGuiParser create(final LittleStructure structure, GuiParent parent, AnimationGuiHandler handler) {
                if (structure instanceof LittleFrame) {
                    return new LittleStructureGuiParser(parent, handler){

                        protected LittleStructure parseStructure(LittlePreviews previews) {
                            LittleStructure parsedStructure = structure.type.createStructure(null);
                            parsedStructure.loadFromNBT(Objects.requireNonNull(previews.structureNBT));
                            return parsedStructure;
                        }

                        protected void createControls(LittlePreviews previews, LittleStructure structure2) {
                        }

                        protected LittleStructureType getStructureType() {
                            return structure.type;
                        }
                    };
                }
                return null;
            }
        });
    }
}

