/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.model.search;

import com.github.kiulian.downloader.model.search.SearchResultChannelDetails;
import com.github.kiulian.downloader.model.search.SearchResultItem;
import com.github.kiulian.downloader.model.search.SearchResultItemType;
import com.github.kiulian.downloader.model.search.SearchResultPlaylistDetails;
import com.github.kiulian.downloader.model.search.SearchResultShelf;
import com.github.kiulian.downloader.model.search.SearchResultVideoDetails;
import com.github.kiulian.downloader.model.search.query.QueryAutoCorrection;
import com.github.kiulian.downloader.model.search.query.QueryElement;
import com.github.kiulian.downloader.model.search.query.QueryElementType;
import com.github.kiulian.downloader.model.search.query.QueryRefinementList;
import com.github.kiulian.downloader.model.search.query.QuerySuggestion;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SearchResult {
    private final long estimatedResults;
    private final List<SearchResultItem> items;
    private final QuerySuggestion suggestion;
    private final QueryRefinementList refinementList;
    private final String autoCorrectedQuery;

    public SearchResult(long estimatedResults, List<SearchResultItem> items, Map<QueryElementType, QueryElement> queryElements) {
        this.estimatedResults = estimatedResults;
        this.items = items;
        this.suggestion = (QuerySuggestion)queryElements.get((Object)QueryElementType.SUGGESTION);
        this.refinementList = (QueryRefinementList)queryElements.get((Object)QueryElementType.REFINEMENT_LIST);
        this.autoCorrectedQuery = queryElements.containsKey((Object)QueryElementType.AUTO_CORRECTION) ? ((QueryAutoCorrection)queryElements.get((Object)QueryElementType.AUTO_CORRECTION)).query() : null;
    }

    public QuerySuggestion suggestion() {
        return this.suggestion;
    }

    public QueryRefinementList refinements() {
        return this.refinementList;
    }

    public boolean isAutoCorrected() {
        return this.autoCorrectedQuery != null;
    }

    public String autoCorrectedQuery() {
        return this.autoCorrectedQuery;
    }

    public List<SearchResultVideoDetails> videos() {
        LinkedList<SearchResultVideoDetails> videos = new LinkedList<SearchResultVideoDetails>();
        for (SearchResultItem item : this.items) {
            if (item.type() != SearchResultItemType.VIDEO) continue;
            videos.add(item.asVideo());
        }
        return videos;
    }

    public List<SearchResultChannelDetails> channels() {
        LinkedList<SearchResultChannelDetails> channels = new LinkedList<SearchResultChannelDetails>();
        for (SearchResultItem item : this.items) {
            if (item.type() != SearchResultItemType.CHANNEL) continue;
            channels.add(item.asChannel());
        }
        return channels;
    }

    public List<SearchResultPlaylistDetails> playlists() {
        LinkedList<SearchResultPlaylistDetails> videos = new LinkedList<SearchResultPlaylistDetails>();
        for (SearchResultItem item : this.items) {
            if (item.type() != SearchResultItemType.PLAYLIST) continue;
            videos.add(item.asPlaylist());
        }
        return videos;
    }

    public List<SearchResultShelf> shelves() {
        LinkedList<SearchResultShelf> shelves = new LinkedList<SearchResultShelf>();
        for (SearchResultItem item : this.items) {
            if (item.type() != SearchResultItemType.SHELF) continue;
            shelves.add(item.asShelf());
        }
        return shelves;
    }

    public boolean hasContinuation() {
        return false;
    }

    public long estimatedResults() {
        return this.estimatedResults;
    }

    public List<SearchResultItem> items() {
        return this.items;
    }
}

