/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.model;

import com.alibaba.fastjson.JSONObject;
import com.github.kiulian.downloader.model.Utils;
import java.util.List;

public abstract class AbstractVideoDetails {
    protected String videoId;
    private List<String> thumbnails;
    protected int lengthSeconds;
    protected String title;
    protected String author;
    protected boolean isLive;

    protected boolean isDownloadable() {
        return !this.isLive() && this.lengthSeconds() != 0;
    }

    public AbstractVideoDetails() {
    }

    public AbstractVideoDetails(JSONObject json) {
        this.videoId = json.getString("videoId");
        if (json.containsKey("lengthSeconds")) {
            this.lengthSeconds = json.getIntValue("lengthSeconds");
        }
        this.thumbnails = Utils.parseThumbnails(json.getJSONObject("thumbnail"));
    }

    public String videoId() {
        return this.videoId;
    }

    public String title() {
        return this.title;
    }

    public int lengthSeconds() {
        return this.lengthSeconds;
    }

    public List<String> thumbnails() {
        return this.thumbnails;
    }

    public String author() {
        return this.author;
    }

    public boolean isLive() {
        return this.isLive;
    }
}

