/*
 * Decompiled with CFR 0.152.
 */
package com.tlf.HN.event;

import com.tlf.HN.common.HideNames;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventHandler {
    private final boolean client = FMLCommonHandler.instance().getEffectiveSide().isClient();
    private int tickCount = 0;

    public EventHandler() {
        System.out.println("HN Event Handler started on side " + FMLCommonHandler.instance().getEffectiveSide());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderLiving(RenderLivingEvent.Specials.Pre event) {
        Boolean hidden;
        if (event.getEntity() instanceof EntityPlayer && event.isCancelable() && (hidden = HideNames.INSTANCE.hiddenPlayers.get(event.getEntity().func_174793_f().func_70005_c_().toLowerCase())) != null && hidden.booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!this.client) {
            HideNames.INSTANCE.onClientConnect(event.player);
        }
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.onTickInGame();
        }
    }

    private void onTickInGame() {
        String[] users;
        if (!HideNames.saveOfflinePlayers) {
            HideNames.INSTANCE.removeOfflinePlayers();
        }
        HideNames.INSTANCE.checkFile();
        for (String user : users = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_72369_d()) {
            if (HideNames.INSTANCE.hiddenPlayers.containsKey(user.toLowerCase()) && HideNames.INSTANCE.hiddenPlayers.get(user.toLowerCase()) != null) continue;
            EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184102_h().func_184103_al().func_152612_a(user);
            HideNames.INSTANCE.updateHiddenPlayers(user, HideNames.defaultHiddenStatus);
            player.func_145747_a((ITextComponent)new TextComponentString("Your name is: " + (HideNames.defaultHiddenStatus ? "\u00a7a Hidden" : "\u00a74 Visible")));
        }
        if (this.tickCount == 20) {
            this.tickCount = 0;
            Configuration tempConfig = HideNames.INSTANCE.config;
            tempConfig.load();
            if (HideNames.defaultHiddenStatus != tempConfig.get("general", "defaultHiddenStatus", false, "Default state for new players").getBoolean(false)) {
                Property temp = tempConfig.get("general", "defaultHiddenStatus", false, "Default state for new players");
                temp.set(HideNames.defaultHiddenStatus);
            }
            if (HideNames.showHideStatusOnLogin != tempConfig.get("general", "showHideStatusOnLogin", true, "Showing information about hide status after enter the game").getBoolean(true)) {
                Property temp = tempConfig.get("general", "showHideStatusOnLogin", true, "Showing information about hide status after enter the game");
                temp.set(HideNames.showHideStatusOnLogin);
            }
            if (HideNames.saveOfflinePlayers != tempConfig.get("general", "saveOfflinePlayers", true, "Whether or not to keep players in 'hidden.txt' if they are offline - useful for big servers").getBoolean(true)) {
                Property temp = tempConfig.get("general", "saveOfflinePlayers", true, "Whether or not to keep players in 'hidden.txt' if they are offline - useful for big servers");
                temp.set(HideNames.saveOfflinePlayers);
            }
            if (HideNames.allowCommand != tempConfig.get("general", "allowCommand", true, "Whether or not non-ops can use the /name command").getBoolean(true)) {
                Property temp = tempConfig.get("general", "allowCommand", true, "Whether or not non-ops can use the /name command");
                temp.set(HideNames.allowCommand);
            }
            tempConfig.save();
        } else {
            ++this.tickCount;
        }
    }
}

