/*
 * Decompiled with CFR 0.152.
 */
package com.tlf.HN.common;

import com.tlf.HN.commands.CommandName;
import com.tlf.HN.event.EventHandler;
import com.tlf.HN.network.packet.PacketHNChange;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="hidenames", name="HideNames", version="1.4.1", acceptedMinecraftVersions="[1.12.2]")
public class HideNames {
    public static final String MODID = "hidenames";
    public static final String NAME = "HideNames";
    public static final String VERSION = "1.4.1";
    @Mod.Instance(value="hidenames")
    public static HideNames INSTANCE;
    public Configuration config;
    public String channel;
    public SimpleNetworkWrapper network;
    public final Map<String, Boolean> hiddenPlayers = new HashMap<String, Boolean>();
    public final Logger LOGGER = Logger.getLogger("Minecraft");
    public static final int commandPermissionLevel = 0;
    public static final String commandName1 = "name";
    public static final String commandName2 = "names";
    public String fileHiddenPlayers;
    public final String fileName = "hidden.txt";
    public String serverFilePath;
    public String clientFilePath;
    public static boolean defaultHiddenStatus;
    public static boolean saveOfflinePlayers;
    public static boolean allowCommand;
    public static boolean showHideStatusOnLogin;
    private ModMetadata metadata;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        this.metadata = event.getModMetadata();
        this.channel = this.metadata.modId;
        this.config = new Configuration(new File(event.getModConfigurationDirectory(), "/tlf/HideNames.cfg"));
        this.config.load();
        defaultHiddenStatus = this.config.get("general", "defaultHiddenStatus", false, "Default state for new players").getBoolean(false);
        showHideStatusOnLogin = this.config.get("general", "showHideStatusOnLogin", true, "Showing information about hide status after enter the game").getBoolean(true);
        saveOfflinePlayers = this.config.get("general", "saveOfflinePlayers", true, "Whether or not to keep players in 'hidden.txt' if they are offline - useful for big servers").getBoolean(true);
        allowCommand = this.config.get("general", "allowCommand", true, "Whether or not non-ops can use the /name command").getBoolean(true);
        this.serverFilePath = this.config.get("general", "serverFilePath", "", "Where the file 'hidden.txt' should be on a dedicated server - NOTE: all directories are located within the server folder").getString();
        this.clientFilePath = this.config.get("general", "clientFilePath", "/config/tlf", "Where the file 'hidden.txt' should be on a client/LAN server - NOTE: all directories are located within the '.minecraft' folder").getString();
        this.config.save();
        this.network = NetworkRegistry.INSTANCE.newSimpleChannel(this.channel);
        this.network.registerMessage(PacketHNChange.Handler.class, PacketHNChange.class, 0, Side.CLIENT);
    }

    @Mod.EventHandler
    public void onModInit(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    @Mod.EventHandler
    public void onModLoad(FMLPostInitializationEvent event) {
        this.LOGGER.info(this.metadata.name + " " + this.metadata.version + " loaded!");
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandName());
        this.getFilePath();
        this.getHiddenPlayers();
    }

    public void getFilePath() {
        this.fileHiddenPlayers = FMLCommonHandler.instance().getMinecraftServerInstance().func_184102_h().func_71262_S() ? (!this.serverFilePath.endsWith("/") ? (!"hidden.txt".startsWith("/") ? this.serverFilePath + "/" + "hidden.txt" : this.serverFilePath + "hidden.txt") : (!"hidden.txt".startsWith("/") ? this.serverFilePath + "hidden.txt" : this.serverFilePath.substring(0, this.serverFilePath.length() - 1) + "hidden.txt")) : (!this.clientFilePath.endsWith("/") ? (!"hidden.txt".startsWith("/") ? this.clientFilePath + "/" + "hidden.txt" : this.clientFilePath + "hidden.txt") : (!"hidden.txt".startsWith("/") ? this.clientFilePath + "hidden.txt" : this.clientFilePath.substring(0, this.clientFilePath.length() - 1) + "hidden.txt"));
        if (this.fileHiddenPlayers.startsWith("/")) {
            this.fileHiddenPlayers = this.fileHiddenPlayers.substring(1);
        }
    }

    public void clearHiddenPlayers() {
        this.hiddenPlayers.clear();
        new File(this.fileHiddenPlayers).delete();
    }

    public void getHiddenPlayers() {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.fileHiddenPlayers));
            this.hiddenPlayers.clear();
            while ((line = br.readLine()) != null) {
                if (line.length() <= 0 || line.substring(0, 1).contentEquals("#")) continue;
                int seperator = line.lastIndexOf(":");
                String username = line.substring(0, seperator).toLowerCase();
                String hidden = line.substring(seperator + 1);
                this.updateHiddenPlayers(username, hidden.equalsIgnoreCase("true"));
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            this.LOGGER.log(Level.FINE, "Error: File " + this.fileHiddenPlayers + " not found.");
            this.LOGGER.log(Level.FINE, "Creating file " + this.fileHiddenPlayers);
            this.createFile(this.fileHiddenPlayers);
        }
        catch (IOException e) {
            this.LOGGER.log(Level.WARNING, "Error: " + e.getMessage());
        }
    }

    public void onClientConnect(EntityPlayer player) {
        for (String user : this.hiddenPlayers.keySet()) {
            this.network.sendTo((IMessage)new PacketHNChange(user, (boolean)this.hiddenPlayers.get(user)), (EntityPlayerMP)player);
        }
        String username = player.func_174793_f().func_70005_c_().toLowerCase();
        if (this.hiddenPlayers.get(username) == null) {
            this.updateHiddenPlayers(username, defaultHiddenStatus);
        } else {
            this.updateHiddenPlayers(username, this.hiddenPlayers.get(username));
        }
        if (showHideStatusOnLogin) {
            player.func_145747_a((ITextComponent)new TextComponentString("Your name is: " + (this.hiddenPlayers.get(username) != false ? "\u00a7aHidden" : "\u00a74Visible")));
        }
    }

    private void createFile(String file) {
        try {
            FileWriter fstream = new FileWriter(file);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write("#List of Hidden Players");
            Iterator<Map.Entry<String, Boolean>> iterator = this.hiddenPlayers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Boolean> o;
                Map.Entry<String, Boolean> mEntry = o = iterator.next();
                out.write("\n" + mEntry.getKey() + ":" + (mEntry.getValue() != false ? "true" : "false"));
            }
            out.close();
            fstream.close();
        }
        catch (Exception e) {
            this.LOGGER.log(Level.WARNING, "Error: " + e.getMessage());
        }
    }

    public void setAll(String sender, boolean hidden) {
        ArrayList<String> users = new ArrayList<String>();
        for (Map.Entry<String, Boolean> entry : this.hiddenPlayers.entrySet()) {
            String key = entry.getKey();
            users.add(key);
        }
        for (String username : users) {
            this.updateHiddenPlayers(username, hidden);
            if (username.equalsIgnoreCase(sender)) continue;
            HideNames.playerForName(username).func_145747_a((ITextComponent)new TextComponentString(sender + " set your name to be: " + (this.hiddenPlayers.get(username) != false ? TextFormatting.GREEN + "Hidden" : TextFormatting.DARK_RED + "Visible")));
        }
    }

    public void updateHiddenPlayers(String username, boolean hidden) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            username = username.toLowerCase();
            this.hiddenPlayers.remove(username);
            this.hiddenPlayers.put(username, hidden);
            this.refreshFile(this.fileHiddenPlayers);
            this.network.sendToAll((IMessage)new PacketHNChange(username, hidden));
        }
    }

    public void removeOfflinePlayers() {
        int i;
        String[] users = FMLCommonHandler.instance().getMinecraftServerInstance().func_184102_h().func_71213_z();
        Object[] keySet = this.hiddenPlayers.keySet().toArray();
        Boolean[] keepUsers = new Boolean[keySet.length];
        Boolean foundUser = false;
        Boolean foundDifferent = false;
        for (i = 0; i < keySet.length; ++i) {
            for (String user : users) {
                if (!keySet[i].toString().equalsIgnoreCase(user)) continue;
                foundUser = true;
            }
            if (!foundUser.booleanValue()) {
                foundDifferent = true;
            }
            keepUsers[i] = foundUser;
            foundUser = false;
        }
        for (i = 0; i < keepUsers.length; ++i) {
            if (keepUsers[i].booleanValue()) continue;
            this.hiddenPlayers.remove(keySet[i]);
        }
        if (foundDifferent.booleanValue()) {
            this.refreshFile(this.fileHiddenPlayers);
        }
    }

    public void refreshFile(String fileName) {
        new File(fileName).delete();
        this.createFile(fileName);
    }

    public void checkFile() {
        File file = new File(this.fileHiddenPlayers);
        if (!file.exists()) {
            this.createFile(this.fileHiddenPlayers);
        }
    }

    public static EntityPlayerMP playerForName(String username) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(username);
    }

    public static String colorBool(boolean bool) {
        return bool ? TextFormatting.GREEN + "true" : TextFormatting.DARK_RED + "false";
    }
}

