/*
 * Decompiled with CFR 0.152.
 */
package cityofskytcd.chineseworkshop.network;

import cityofskytcd.chineseworkshop.CW;
import cityofskytcd.chineseworkshop.network.CWPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class CWNetworkChannel {
    public static final CWNetworkChannel INSTANCE = new CWNetworkChannel();
    private final Object2IntMap<Class<? extends CWPacket>> mapping = new Object2IntArrayMap();
    private final Int2ObjectMap<Class<? extends CWPacket>> mappingReverse = new Int2ObjectArrayMap();
    private int nextIndex = 0;
    private final FMLEventChannel channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("chineseworkshop");

    private CWNetworkChannel() {
        this.channel.register((Object)this);
    }

    @SubscribeEvent
    public void onServerPacketIncoming(FMLNetworkEvent.ServerCustomPacketEvent event) {
        this.handleOnServer(this.decodeData(event.getPacket().payload()), ((NetHandlerPlayServer)event.getHandler()).field_147369_b);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientPacketIncoming(FMLNetworkEvent.ClientCustomPacketEvent event) {
        this.handleOnClient(this.decodeData(event.getPacket().payload()), Minecraft.func_71410_x().field_71439_g);
    }

    public void sendToAll(CWPacket packet) {
        this.channel.sendToAll(new FMLProxyPacket(new PacketBuffer(this.unpack(packet)), "chineseworkshop"));
    }

    public void sendToAllAround(CWPacket packet, int dim, double x, double y, double z, double range) {
        this.channel.sendToAllAround(new FMLProxyPacket(new PacketBuffer(this.unpack(packet)), "chineseworkshop"), new NetworkRegistry.TargetPoint(dim, x, y, z, range));
    }

    public void sendToDimension(CWPacket packet, int dim) {
        this.channel.sendToDimension(new FMLProxyPacket(new PacketBuffer(this.unpack(packet)), "chineseworkshop"), dim);
    }

    public void sendToPlayer(CWPacket packet, EntityPlayerMP player) {
        this.channel.sendTo(new FMLProxyPacket(new PacketBuffer(this.unpack(packet)), "chineseworkshop"), player);
    }

    public void sendToServer(CWPacket packet) {
        this.channel.sendToServer(new FMLProxyPacket(new PacketBuffer(this.unpack(packet)), "chineseworkshop"));
    }

    public void register(Class<? extends CWPacket> klass) {
        this.mapping.put(klass, this.nextIndex);
        this.mappingReverse.put(this.nextIndex, klass);
        ++this.nextIndex;
    }

    private int getPacketIndex(Class<? extends CWPacket> klass) {
        return this.mapping.getInt(klass);
    }

    private CWPacket getByIndex(int index) {
        try {
            return (CWPacket)((Class)this.mappingReverse.get(index)).newInstance();
        }
        catch (Exception e) {
            CW.logger.catching((Throwable)e);
            return null;
        }
    }

    private CWPacket decodeData(ByteBuf buffer) {
        int index = buffer.readInt();
        CWPacket packet = this.getByIndex(index);
        if (packet == null) {
            CW.logger.error("Receiving malformed packet");
            return null;
        }
        packet.readDataFrom(buffer);
        return packet;
    }

    @SideOnly(value=Side.CLIENT)
    private void handleOnClient(CWPacket packet, EntityPlayerSP player) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            try {
                packet.handleClient(player);
            }
            catch (Exception e) {
                CW.logger.catching((Throwable)e);
            }
        });
    }

    private void handleOnServer(CWPacket packet, EntityPlayerMP player) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> {
            try {
                packet.handleServer(player);
            }
            catch (Exception e) {
                CW.logger.catching((Throwable)e);
            }
        });
    }

    private ByteBuf unpack(CWPacket packet) {
        ByteBuf buffer = Unpooled.buffer();
        buffer.writeInt(this.getPacketIndex(packet.getClass()));
        try {
            packet.writeDataTo(buffer);
        }
        catch (Exception e) {
            CW.logger.catching((Throwable)e);
        }
        return buffer;
    }
}

