/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture.ctx;

import com.google.common.collect.ObjectArrays;
import java.beans.ConstructorProperties;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.ArrayUtils;
import team.chisel.ctm.api.texture.ITextureContext;
import team.chisel.ctm.client.util.ConnectionLocations;

public class TextureContextCTMV
implements ITextureContext {
    private static final ConnectionLocations[] MAIN_VALUES = new ConnectionLocations[]{ConnectionLocations.UP, ConnectionLocations.DOWN, ConnectionLocations.NORTH, ConnectionLocations.SOUTH, ConnectionLocations.EAST, ConnectionLocations.WEST};
    private static final ConnectionLocations[] OFFSET_VALUES = (ConnectionLocations[])ArrayUtils.removeElements((Object[])ConnectionLocations.VALUES, (Object[])ObjectArrays.concat((Object[])new ConnectionLocations[]{ConnectionLocations.NORTH_EAST_UP, ConnectionLocations.NORTH_EAST_DOWN, ConnectionLocations.NORTH_WEST_UP, ConnectionLocations.NORTH_WEST_DOWN, ConnectionLocations.SOUTH_WEST_UP, ConnectionLocations.SOUTH_WEST_DOWN, ConnectionLocations.SOUTH_EAST_UP, ConnectionLocations.SOUTH_EAST_DOWN}, (Object[])MAIN_VALUES, ConnectionLocations.class));
    private static final ConnectionLocations[] ALL_VALUES = (ConnectionLocations[])ObjectArrays.concat((Object[])MAIN_VALUES, (Object[])OFFSET_VALUES, ConnectionLocations.class);
    private ConnectionData data;
    private long compressedData;

    public TextureContextCTMV(IBlockAccess world, BlockPos pos) {
        this.data = new ConnectionData(world, pos);
        IBlockState state = world.func_180495_p(pos);
        for (ConnectionLocations loc : ALL_VALUES) {
            if (state != world.func_180495_p(loc.transform(pos))) continue;
            this.compressedData |= loc.getMask();
        }
    }

    public TextureContextCTMV(long data) {
        this.data = new ConnectionData(data);
    }

    @Override
    public long getCompressedData() {
        return this.compressedData;
    }

    public ConnectionData getData() {
        return this.data;
    }

    public static class ConnectionData {
        private Connections connections;
        private Map<EnumFacing, Connections> connectionConnections = new EnumMap<EnumFacing, Connections>(EnumFacing.class);

        public ConnectionData(IBlockAccess world, BlockPos pos) {
            this.connections = Connections.forPos(world, pos);
            IBlockState state = world.func_180495_p(pos);
            for (EnumFacing f : EnumFacing.field_82609_l) {
                this.connectionConnections.put(f, Connections.forPos(world, state, pos.func_177972_a(f)));
            }
        }

        public ConnectionData(long data) {
            this.connections = Connections.forData(data, null);
            for (EnumFacing f : EnumFacing.field_82609_l) {
                this.connectionConnections.put(f, Connections.forData(data, f));
            }
        }

        public Connections getConnections(EnumFacing facing) {
            return this.connectionConnections.get(facing);
        }

        public String toString() {
            return "TextureContextCTMV.ConnectionData(connections=" + this.getConnections() + ", connectionConnections=" + this.connectionConnections + ")";
        }

        public Connections getConnections() {
            return this.connections;
        }
    }

    public static class Connections {
        private EnumSet<EnumFacing> connections;

        public boolean connected(EnumFacing facing) {
            return this.connections.contains(facing);
        }

        public boolean connectedAnd(EnumFacing ... facings) {
            for (EnumFacing f : facings) {
                if (this.connected(f)) continue;
                return false;
            }
            return true;
        }

        public boolean connectedOr(EnumFacing ... facings) {
            for (EnumFacing f : facings) {
                if (!this.connected(f)) continue;
                return true;
            }
            return false;
        }

        public static Connections forPos(IBlockAccess world, BlockPos pos) {
            IBlockState state = world.func_180495_p(pos);
            return Connections.forPos(world, state, pos);
        }

        public static Connections forData(long data, EnumFacing offset) {
            EnumSet<EnumFacing> connections = EnumSet.noneOf(EnumFacing.class);
            if (offset == null) {
                for (ConnectionLocations loc : MAIN_VALUES) {
                    if ((data & loc.getMask()) == 0L) continue;
                    connections.add(ConnectionLocations.toFacing(loc));
                }
            } else {
                for (ConnectionLocations loc : OFFSET_VALUES) {
                    EnumFacing facing;
                    if ((data & loc.getMask()) == 0L || (facing = loc.clipOrDestroy(offset)) == null) continue;
                    connections.add(facing);
                }
            }
            return new Connections(connections);
        }

        public static Connections forPos(IBlockAccess world, IBlockState baseState, BlockPos pos) {
            EnumSet<EnumFacing> connections = EnumSet.noneOf(EnumFacing.class);
            IBlockState state = world.func_180495_p(pos);
            if (state == baseState) {
                for (EnumFacing f : EnumFacing.field_82609_l) {
                    if (world.func_180495_p(pos.func_177972_a(f)) != baseState) continue;
                    connections.add(f);
                }
            }
            return new Connections(connections);
        }

        @ConstructorProperties(value={"connections"})
        public Connections(EnumSet<EnumFacing> connections) {
            this.connections = connections;
        }

        public EnumSet<EnumFacing> getConnections() {
            return this.connections;
        }

        public String toString() {
            return "TextureContextCTMV.Connections(connections=" + this.getConnections() + ")";
        }
    }
}

