/*
 * Decompiled with CFR 0.152.
 */
package com.goodbird.cnpcgeckoaddon.utils;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.File;
import java.security.MessageDigest;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.client.ImageDownloadAlt;
import noppes.npcs.client.renderer.ImageBufferDownloadAlt;
import noppes.npcs.client.renderer.RenderNPCInterface;
import noppes.npcs.entity.EntityNPCInterface;

public class NpcTextureUtils {
    public static ResourceLocation getNpcTexture(EntityNPCInterface npc) {
        if (npc.textureLocation == null) {
            if (npc.display.skinType == 0) {
                npc.textureLocation = new ResourceLocation(npc.display.getSkinTexture());
            } else {
                if (RenderNPCInterface.LastTextureTick < 5) {
                    return DefaultPlayerSkin.func_177335_a();
                }
                if (npc.display.skinType == 1 && npc.display.playerProfile != null) {
                    Minecraft minecraft = Minecraft.func_71410_x();
                    Map map = minecraft.func_152342_ad().func_152788_a(npc.display.playerProfile);
                    if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                        npc.textureLocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                    }
                } else if (npc.display.skinType == 2) {
                    try {
                        MessageDigest digest = MessageDigest.getInstance("MD5");
                        byte[] hash = digest.digest(npc.display.getSkinUrl().getBytes("UTF-8"));
                        StringBuilder sb = new StringBuilder(2 * hash.length);
                        byte[] var5 = hash;
                        int var6 = hash.length;
                        for (int var7 = 0; var7 < var6; ++var7) {
                            byte b = var5[var7];
                            sb.append(String.format("%02x", b & 0xFF));
                        }
                        npc.textureLocation = new ResourceLocation("skins/" + sb.toString());
                        NpcTextureUtils.loadSkin(null, npc.textureLocation, npc.display.getSkinUrl());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return npc.textureLocation == null ? DefaultPlayerSkin.func_177335_a() : npc.textureLocation;
    }

    private static void loadSkin(File file, ResourceLocation resource, String par1Str) {
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        if (texturemanager.func_110581_b(resource) == null) {
            ImageDownloadAlt object = new ImageDownloadAlt(file, par1Str, DefaultPlayerSkin.func_177335_a(), (IImageBuffer)new ImageBufferDownloadAlt());
            texturemanager.func_110579_a(resource, (ITextureObject)object);
        }
    }
}

