/*
 * Decompiled with CFR 0.152.
 */
package com.goodbird.cnpcgeckoaddon.network;

import com.goodbird.cnpcgeckoaddon.tile.TileEntityCustomModel;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import noppes.npcs.Server;
import noppes.npcs.blocks.tiles.TileScripted;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.builder.RawAnimation;

public class CPacketSyncTileManualAnim
implements IMessage,
IMessageHandler<CPacketSyncTileManualAnim, IMessage> {
    public AnimationBuilder builder;
    public BlockPos pos;

    public CPacketSyncTileManualAnim() {
    }

    public CPacketSyncTileManualAnim(TileEntity tile, AnimationBuilder builder) {
        this.builder = builder;
        this.pos = tile.func_174877_v();
    }

    public void toBytes(ByteBuf buf) {
        try {
            CPacketSyncTileManualAnim.writeAnimBuilder(buf, this.builder);
        }
        catch (Exception exception) {
            // empty catch block
        }
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.builder = CPacketSyncTileManualAnim.readAnimBuilder(buf);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void writeAnimBuilder(ByteBuf buffer, AnimationBuilder builder) throws IOException {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList animList = new NBTTagList();
        for (RawAnimation anim : builder.getRawAnimationList()) {
            NBTTagCompound animTag = new NBTTagCompound();
            animTag.func_74778_a("name", anim.animationName);
            if (anim.loopType != null) {
                animTag.func_74768_a("loop", ((ILoopType.EDefaultLoopTypes)anim.loopType).ordinal());
            } else {
                animTag.func_74768_a("loop", 1);
            }
            animList.func_74742_a((NBTBase)animTag);
        }
        compound.func_74782_a("anims", (NBTBase)animList);
        Server.writeNBT((ByteBuf)buffer, (NBTTagCompound)compound);
    }

    public static AnimationBuilder readAnimBuilder(ByteBuf buffer) throws IOException {
        AnimationBuilder builder = new AnimationBuilder();
        NBTTagCompound compound = Server.readNBT((ByteBuf)buffer);
        NBTTagList animList = compound.func_150295_c("anims", 10);
        for (int i = 0; i < animList.func_74745_c(); ++i) {
            NBTTagCompound animTag = animList.func_150305_b(i);
            builder.addAnimation(animTag.func_74779_i("name"), (ILoopType)ILoopType.EDefaultLoopTypes.values()[animTag.func_74762_e("loop")]);
        }
        return builder;
    }

    public IMessage onMessage(CPacketSyncTileManualAnim message, MessageContext ctx) {
        TileEntity entity = Minecraft.func_71410_x().field_71441_e.func_175625_s(message.pos);
        if (!(entity instanceof TileScripted)) {
            return null;
        }
        TileScripted tile = (TileScripted)entity;
        if (tile.renderTile == null) {
            tile.renderTile = new TileEntityCustomModel();
        }
        TileEntityCustomModel geckoTile = (TileEntityCustomModel)tile.renderTile;
        geckoTile.manualAnim = message.builder;
        return null;
    }
}

