/*
 * Decompiled with CFR 0.152.
 */
package com.goodbird.cnpcgeckoaddon.hooklib.cnpchooks;

import com.goodbird.cnpcgeckoaddon.CNPCGeckoAddon;
import com.goodbird.cnpcgeckoaddon.data.CustomModelDataProvider;
import com.goodbird.cnpcgeckoaddon.data.ICustomModelData;
import com.goodbird.cnpcgeckoaddon.entity.EntityCustomModel;
import com.goodbird.cnpcgeckoaddon.hooklib.asm.Hook;
import com.goodbird.cnpcgeckoaddon.hooklib.asm.ReturnCondition;
import com.goodbird.cnpcgeckoaddon.network.CPacketSyncTileManualAnim;
import com.goodbird.cnpcgeckoaddon.network.NetworkWrapper;
import com.goodbird.cnpcgeckoaddon.network.PacketSyncAnimation;
import com.goodbird.cnpcgeckoaddon.tile.TileEntityCustomModel;
import com.goodbird.cnpcgeckoaddon.utils.NpcTextureUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.api.block.IBlockScripted;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.wrapper.BlockScriptedWrapper;
import noppes.npcs.api.wrapper.NPCWrapper;
import noppes.npcs.api.wrapper.WrapperNpcAPI;
import noppes.npcs.blocks.tiles.TileScripted;
import noppes.npcs.client.EntityUtil;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataDisplay;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.manager.AnimationData;

public class CommonHooks {
    @Hook(injectOnExit=true)
    public static void writeToNBT(DataDisplay data, NBTTagCompound nbttagcompound) {
        ICustomModelData modeldata = (ICustomModelData)data.npc.getCapability(CustomModelDataProvider.DATA_CAP, null);
        if (modeldata != null) {
            modeldata.writeToNBT(nbttagcompound);
        }
    }

    @Hook(injectOnExit=true)
    public static void readToNBT(DataDisplay data, NBTTagCompound nbttagcompound) {
        ICustomModelData modeldata = (ICustomModelData)data.npc.getCapability(CustomModelDataProvider.DATA_CAP, null);
        if (modeldata != null) {
            modeldata.readFromNBT(nbttagcompound);
        }
    }

    @Hook(createMethod=true, returnCondition=ReturnCondition.ALWAYS)
    public static AnimationBuilder createAnimBuilder(WrapperNpcAPI api) {
        return new AnimationBuilder();
    }

    private static ICustomModelData getModelData(EntityNPCInterface npc) {
        return (ICustomModelData)npc.getCapability(CustomModelDataProvider.DATA_CAP, null);
    }

    @Hook(createMethod=true, returnCondition=ReturnCondition.ALWAYS)
    public static void setGeckoModel(NPCWrapper<EntityNPCInterface> npc, String model) {
        CommonHooks.getModelData((EntityNPCInterface)npc.getMCEntity()).setModel(model);
        npc.updateClient();
    }

    @Hook(createMethod=true, returnCondition=ReturnCondition.ALWAYS)
    public static void setGeckoTexture(NPCWrapper<EntityNPCInterface> npc, String texture) {
        ((EntityNPCInterface)npc.getMCEntity()).display.setSkinTexture(texture);
        npc.updateClient();
    }

    @Hook(createMethod=true, returnCondition=ReturnCondition.ALWAYS)
    public static void setGeckoAnimationFile(NPCWrapper<EntityNPCInterface> npc, String animation) {
        CommonHooks.getModelData((EntityNPCInterface)npc.getMCEntity()).setAnimFile(animation);
        npc.updateClient();
    }

    @Hook(createMethod=true, returnCondition=ReturnCondition.ALWAYS)
    public static void setGeckoIdleAnimation(NPCWrapper<EntityNPCInterface> npc, String animation) {
        CommonHooks.getModelData((EntityNPCInterface)npc.getMCEntity()).setIdleAnim(animation);
        npc.updateClient();
    }

    @Hook(createMethod=true, returnCondition=ReturnCondition.ALWAYS)
    public static void setGeckoWalkAnimation(NPCWrapper<EntityNPCInterface> npc, String animation) {
        CommonHooks.getModelData((EntityNPCInterface)npc.getMCEntity()).setWalkAnim(animation);
        npc.updateClient();
    }

    @Hook(createMethod=true, returnCondition=ReturnCondition.ALWAYS)
    public static void syncAnimationsFor(NPCWrapper<EntityNPCInterface> wrapper, IPlayer player, AnimationBuilder builder) {
        NetworkWrapper.sendToPlayer(new PacketSyncAnimation((EntityNPCInterface)wrapper.getMCEntity(), builder), (EntityPlayer)player.getMCEntity());
    }

    @Hook(createMethod=true, returnCondition=ReturnCondition.ALWAYS)
    public static void syncAnimationsForAll(NPCWrapper<EntityNPCInterface> wrapper, AnimationBuilder builder) {
        NetworkWrapper.sendToAll(new PacketSyncAnimation((EntityNPCInterface)wrapper.getMCEntity(), builder));
    }

    @Hook(injectOnExit=true)
    public static void onUpdate(EntityCustomNpc npc) {
        ICustomModelData data = (ICustomModelData)npc.getCapability(CustomModelDataProvider.DATA_CAP, null);
        if (data == null) {
            return;
        }
        EntityLivingBase entity = npc.modelData.getEntity((EntityNPCInterface)npc);
        if (!(entity instanceof EntityCustomModel)) {
            return;
        }
        EntityCustomModel modelEntity = (EntityCustomModel)entity;
        if (data.getHeight() != modelEntity.field_70131_O || data.getWidth() != modelEntity.field_70130_N) {
            modelEntity.func_70105_a(data.getWidth(), data.getHeight());
            npc.updateHitbox();
        }
    }

    @Hook(injectOnExit=true)
    public static void Copy(EntityUtil cl, EntityLivingBase copied, EntityLivingBase entity) {
        if (entity instanceof EntityCustomModel && copied instanceof EntityNPCInterface) {
            EntityCustomModel modelEntity = (EntityCustomModel)entity;
            EntityNPCInterface npc = (EntityNPCInterface)copied;
            ICustomModelData data = (ICustomModelData)npc.getCapability(CustomModelDataProvider.DATA_CAP, null);
            modelEntity.textureResLoc = NpcTextureUtils.getNpcTexture((EntityNPCInterface)copied);
            modelEntity.modelResLoc = new ResourceLocation(data.getModel());
            modelEntity.animResLoc = new ResourceLocation(data.getAnimFile());
            modelEntity.idleAnimName = data.getIdleAnim();
            modelEntity.walkAnimName = data.getWalkAnim();
            if (!data.isHurtTintEnabled()) {
                npc.field_70737_aN = 0;
                modelEntity.field_70737_aN = 0;
                npc.field_70725_aQ = 0;
                modelEntity.field_70725_aQ = 0;
            }
            if (npc.inventory.getLeftHand() != null) {
                modelEntity.leftHeldItem = npc.inventory.getLeftHand().getMCItemStack();
            }
            modelEntity.headBoneName = data.getHeadBoneName();
            AnimationData animationData = modelEntity.getFactory().getOrCreateAnimationData(Integer.valueOf(modelEntity.func_110124_au().hashCode()));
            for (AnimationController controller : animationData.getAnimationControllers().values()) {
                controller.transitionLengthTicks = data.getTransitionLengthTicks();
            }
            if (data.getHeight() != modelEntity.field_70131_O || data.getWidth() != modelEntity.field_70130_N) {
                modelEntity.func_70105_a(data.getWidth(), data.getHeight());
                npc.updateHitbox();
            }
        }
    }

    @Hook(injectOnExit=true)
    public static void setDisplayNBT(TileScripted tile, NBTTagCompound compound) {
        if (compound.func_74764_b("renderTileTag")) {
            tile.renderTile = new TileEntityCustomModel();
            NBTTagCompound saveTag = compound.func_74775_l("renderTileTag");
            if (saveTag.func_74764_b("dimID")) {
                tile.renderTile.func_145834_a(CNPCGeckoAddon.proxy.getWorldById(saveTag.func_74762_e("dimID")));
            } else {
                tile.renderTile.func_145834_a(CNPCGeckoAddon.proxy.getWorldById(0));
            }
            tile.renderTile.func_145839_a(saveTag);
        }
    }

    @Hook(injectOnExit=true)
    public static void getDisplayNBT(TileScripted tile, NBTTagCompound compound) {
        if (tile.renderTile != null) {
            NBTTagCompound saveTag = new NBTTagCompound();
            tile.renderTile.func_189515_b(saveTag);
            if (tile.renderTile.func_145831_w() != null && tile.renderTile.func_145831_w().field_73011_w != null) {
                saveTag.func_74768_a("dimID", tile.renderTile.func_145831_w().field_73011_w.getDimension());
            }
            compound.func_74782_a("renderTileTag", (NBTBase)saveTag);
        }
    }

    private static TileEntityCustomModel getOrCreateTECM(IBlockScripted scriptedBlock) {
        TileScripted tile = (TileScripted)scriptedBlock.getMCTileEntity();
        if (!(tile.renderTile instanceof TileEntityCustomModel)) {
            tile.renderTile = new TileEntityCustomModel((TileEntity)tile);
        }
        return (TileEntityCustomModel)tile.renderTile;
    }

    @Hook(createMethod=true, returnCondition=ReturnCondition.ALWAYS)
    public static void setGeckoModel(BlockScriptedWrapper scriptedBlock, String model) {
        TileEntityCustomModel geckoTile = CommonHooks.getOrCreateTECM((IBlockScripted)scriptedBlock);
        geckoTile.modelResLoc = new ResourceLocation(model);
        ((TileScripted)scriptedBlock.getMCTileEntity()).needsClientUpdate = true;
    }

    @Hook(createMethod=true, returnCondition=ReturnCondition.ALWAYS)
    public static void setGeckoTexture(BlockScriptedWrapper scriptedBlock, String texture) {
        TileEntityCustomModel geckoTile = CommonHooks.getOrCreateTECM((IBlockScripted)scriptedBlock);
        geckoTile.textureResLoc = new ResourceLocation(texture);
        ((TileScripted)scriptedBlock.getMCTileEntity()).needsClientUpdate = true;
    }

    @Hook(createMethod=true, returnCondition=ReturnCondition.ALWAYS)
    public static void setGeckoAnimationFile(BlockScriptedWrapper scriptedBlock, String animation) {
        TileEntityCustomModel geckoTile = CommonHooks.getOrCreateTECM((IBlockScripted)scriptedBlock);
        geckoTile.animResLoc = new ResourceLocation(animation);
        ((TileScripted)scriptedBlock.getMCTileEntity()).needsClientUpdate = true;
    }

    @Hook(createMethod=true, returnCondition=ReturnCondition.ALWAYS)
    public static void setGeckoIdleAnimation(BlockScriptedWrapper scriptedBlock, String animation) {
        TileEntityCustomModel geckoTile = CommonHooks.getOrCreateTECM((IBlockScripted)scriptedBlock);
        geckoTile.idleAnimName = animation;
        ((TileScripted)scriptedBlock.getMCTileEntity()).needsClientUpdate = true;
    }

    @Hook(createMethod=true, returnCondition=ReturnCondition.ALWAYS)
    public static void syncAnimationsFor(BlockScriptedWrapper scriptedBlock, IPlayer player, AnimationBuilder builder) {
        NetworkWrapper.sendToPlayer(new CPacketSyncTileManualAnim(scriptedBlock.getMCTileEntity(), builder), (EntityPlayer)player.getMCEntity());
    }

    @Hook(createMethod=true, returnCondition=ReturnCondition.ALWAYS)
    public static void syncAnimationsForAll(BlockScriptedWrapper scriptedBlock, AnimationBuilder builder) {
        NetworkWrapper.sendToAll(new CPacketSyncTileManualAnim(scriptedBlock.getMCTileEntity(), builder));
    }
}

