/*
 * Decompiled with CFR 0.152.
 */
package com.goodbird.cnpcgeckoaddon.entity;

import net.minecraft.entity.EntityCreature;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityCustomModel
extends EntityCreature
implements IAnimatable,
IAnimationTickable {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public ResourceLocation modelResLoc = new ResourceLocation("geckolib3", "geo/bike.geo.json");
    public ResourceLocation animResLoc = new ResourceLocation("geckolib3", "animations/bike.animation.json");
    public ResourceLocation textureResLoc = new ResourceLocation("geckolib3", "textures/model/entity/bike.png");
    public String idleAnimName = "";
    public String walkAnimName = "";
    public String hurtAnimName = "";
    public String meleeAttackAnimName = "";
    public String rangedAttackAnimName = "";
    public AnimationBuilder dialogAnim = null;
    public AnimationBuilder manualAnim = null;
    public AnimationBuilder attackAnim = null;
    public AnimationBuilder hurtAnim = null;
    public String headBoneName = "head";
    public ItemStack leftHeldItem;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <E extends IAnimatable> PlayState predicateMovement(AnimationEvent<E> event) {
        if (this.manualAnim != null) {
            if (event.getController().currentAnimationBuilder == this.manualAnim && event.getController().getAnimationState() == AnimationState.Stopped) {
                this.manualAnim = null;
            } else {
                if (event.getController().currentAnimationBuilder != this.manualAnim) {
                    event.getController().markNeedsReload();
                }
                event.getController().setAnimation(this.manualAnim);
                return PlayState.CONTINUE;
            }
        }
        if (this.dialogAnim != null) {
            if (event.getController().currentAnimationBuilder == this.dialogAnim && event.getController().getAnimationState() == AnimationState.Stopped) {
                this.dialogAnim = null;
            } else {
                if (event.getController().currentAnimationBuilder != this.dialogAnim) {
                    event.getController().markNeedsReload();
                }
                event.getController().setAnimation(this.dialogAnim);
                return PlayState.CONTINUE;
            }
        }
        if (!event.isMoving() || this.walkAnimName.isEmpty()) {
            if (this.idleAnimName.isEmpty()) return PlayState.STOP;
            event.getController().setAnimation(new AnimationBuilder().loop(this.idleAnimName));
            return PlayState.CONTINUE;
        } else {
            event.getController().setAnimation(new AnimationBuilder().loop(this.walkAnimName));
        }
        return PlayState.CONTINUE;
    }

    public void setDialogAnim(String name) {
        this.dialogAnim = new AnimationBuilder().playOnce(name);
    }

    public EntityCustomModel(World worldIn) {
        super(worldIn);
        this.field_70158_ak = true;
        this.func_70105_a(0.7f, 2.0f);
    }

    public void func_70105_a(float width, float height) {
        super.func_70105_a(width, height);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "movement", 10.0f, this::predicateMovement));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public int tickTimer() {
        return this.field_70173_aa;
    }

    public void tick() {
        super.func_70071_h_();
    }
}

