/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.world;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.common.IPoint3D;
import moe.plushie.armourers_workshop.api.common.IRectangle3D;
import moe.plushie.armourers_workshop.api.common.skin.cubes.ICubeColour;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinPartType;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.common.exception.SkinSaveException;
import moe.plushie.armourers_workshop.common.init.blocks.ModBlocks;
import moe.plushie.armourers_workshop.common.skin.cubes.CubeColour;
import moe.plushie.armourers_workshop.common.skin.cubes.CubeMarkerData;
import moe.plushie.armourers_workshop.common.skin.cubes.CubeRegistry;
import moe.plushie.armourers_workshop.common.skin.cubes.ICube;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinCubeData;
import moe.plushie.armourers_workshop.common.skin.data.SkinPart;
import moe.plushie.armourers_workshop.common.skin.data.SkinProperties;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import moe.plushie.armourers_workshop.common.skin.type.block.SkinBlock;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityBoundingBox;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityColourable;
import moe.plushie.armourers_workshop.common.world.AsyncWorldUpdateBlock;
import moe.plushie.armourers_workshop.common.world.SyncWorldUpdater;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class ArmourerWorldHelper {
    public static Skin saveSkinFromWorld(World world, SkinProperties skinProps, ISkinType skinType, int[] paintData, BlockPos pos, EnumFacing direction) throws SkinSaveException {
        SkinPart testPart;
        Skin skin;
        ArrayList<SkinPart> parts = new ArrayList<SkinPart>();
        if (skinType == SkinTypeRegistry.skinBlock) {
            SkinPart skinPart;
            ISkinPartType partType = ((SkinBlock)SkinTypeRegistry.skinBlock).partBase;
            if (SkinProperties.PROP_BLOCK_MULTIBLOCK.getValue(skinProps).booleanValue()) {
                partType = ((SkinBlock)SkinTypeRegistry.skinBlock).partMultiblock;
            }
            if ((skinPart = ArmourerWorldHelper.saveArmourPart(world, partType, pos, direction, true)) != null) {
                parts.add(skinPart);
            }
        } else {
            for (int i = 0; i < skinType.getSkinParts().size(); ++i) {
                ISkinPartType partType = skinType.getSkinParts().get(i);
                SkinPart skinPart = ArmourerWorldHelper.saveArmourPart(world, partType, pos, direction, true);
                if (skinPart == null) continue;
                parts.add(skinPart);
            }
        }
        if (paintData != null) {
            paintData = (int[])paintData.clone();
        }
        if ((skin = new Skin(skinProps, skinType, paintData, parts)).getParts().size() == 0 && !skin.hasPaintData()) {
            throw new SkinSaveException("Nothing to save.", SkinSaveException.SkinSaveExceptionType.NO_DATA);
        }
        for (int i = 0; i < skinType.getSkinParts().size(); ++i) {
            ISkinPartType partType = skinType.getSkinParts().get(i);
            if (!partType.isPartRequired()) continue;
            boolean havePart = false;
            for (int j = 0; j < skin.getPartCount(); ++j) {
                if (partType != skin.getParts().get(j).getPartType()) continue;
                havePart = true;
                break;
            }
            if (havePart) continue;
            throw new SkinSaveException("Skin is missing part " + partType.getPartName(), SkinSaveException.SkinSaveExceptionType.MISSING_PARTS);
        }
        if (SkinProperties.PROP_BLOCK_BED.getValue(skinProps) & SkinProperties.PROP_BLOCK_SEAT.getValue(skinProps)) {
            throw new SkinSaveException("Skin can not be a bed and a seat.", SkinSaveException.SkinSaveExceptionType.BED_AND_SEAT);
        }
        if (skinType == SkinTypeRegistry.skinBlock & SkinProperties.PROP_BLOCK_MULTIBLOCK.getValue(skinProps) && (testPart = ArmourerWorldHelper.saveArmourPart(world, ((SkinBlock)SkinTypeRegistry.skinBlock).partBase, pos, direction, true)) == null) {
            throw new SkinSaveException("Multiblock has no blocks in the yellow area.", SkinSaveException.SkinSaveExceptionType.INVALID_MULTIBLOCK);
        }
        return skin;
    }

    private static SkinPart saveArmourPart(World world, ISkinPartType skinPart, BlockPos pos, EnumFacing direction, boolean markerCheck) throws SkinSaveException {
        int cubeCount = ArmourerWorldHelper.getNumberOfCubesInPart(world, pos, skinPart);
        if (cubeCount < 1) {
            return null;
        }
        SkinCubeData cubeData = new SkinCubeData();
        cubeData.setCubeCount(cubeCount);
        ArrayList<CubeMarkerData> markerBlocks = new ArrayList<CubeMarkerData>();
        IRectangle3D buildSpace = skinPart.getBuildingSpace();
        IPoint3D offset = skinPart.getOffset();
        int i = 0;
        for (int ix = 0; ix < buildSpace.getWidth(); ++ix) {
            for (int iy = 0; iy < buildSpace.getHeight(); ++iy) {
                for (int iz = 0; iz < buildSpace.getDepth(); ++iz) {
                    IBlockState blockState;
                    BlockPos target = pos.func_177982_a(ix + -offset.getX() + buildSpace.getX(), iy + -offset.getY(), iz + offset.getZ() + buildSpace.getZ());
                    BlockPos origin = new BlockPos(-ix + -buildSpace.getX(), -iy + -buildSpace.getY(), -iz + -buildSpace.getZ());
                    int xOrigin = -ix + -buildSpace.getX();
                    int yOrigin = -iy + -buildSpace.getY();
                    int zOrigin = -iz + -buildSpace.getZ();
                    if (world.func_175623_d(target) || !CubeRegistry.INSTANCE.isBuildingBlock((blockState = world.func_180495_p(target)).func_177230_c())) continue;
                    ArmourerWorldHelper.saveArmourBlockToList(world, target, xOrigin - 1, yOrigin - 1, -zOrigin, cubeData, i, markerBlocks, direction);
                    ++i;
                }
            }
        }
        if (markerCheck) {
            if (skinPart.getMinimumMarkersNeeded() > markerBlocks.size()) {
                throw new SkinSaveException("Missing marker for part " + skinPart.getPartName(), SkinSaveException.SkinSaveExceptionType.MARKER_ERROR);
            }
            if (markerBlocks.size() > skinPart.getMaximumMarkersNeeded()) {
                throw new SkinSaveException("Too many markers for part " + skinPart.getPartName(), SkinSaveException.SkinSaveExceptionType.MARKER_ERROR);
            }
        }
        return new SkinPart(cubeData, skinPart, markerBlocks);
    }

    private static void saveArmourBlockToList(World world, BlockPos pos, int ix, int iy, int iz, SkinCubeData cubeData, int index, ArrayList<CubeMarkerData> markerBlocks, EnumFacing direction) {
        IBlockState blockState = world.func_180495_p(pos);
        if (!CubeRegistry.INSTANCE.isBuildingBlock(blockState.func_177230_c())) {
            return;
        }
        int meta = blockState.func_177230_c().func_176201_c(blockState);
        ICubeColour c = BlockUtils.getColourFromTileEntity(world, pos);
        byte cubeType = CubeRegistry.INSTANCE.getCubeFromBlock(blockState.func_177230_c()).getId();
        cubeData.setCubeId(index, cubeType);
        cubeData.setCubeLocation(index, (byte)ix, (byte)iy, (byte)iz);
        for (int i = 0; i < 6; ++i) {
            cubeData.setCubeColour(index, i, c.getRed(i), c.getGreen(i), c.getBlue(i));
            cubeData.setCubePaintType(index, i, c.getPaintType(i));
        }
        if (meta > 0) {
            markerBlocks.add(new CubeMarkerData((byte)ix, (byte)iy, (byte)iz, (byte)meta));
        }
    }

    public static void loadSkinIntoWorld(World world, BlockPos pos, Skin skin, EnumFacing direction) {
        ArrayList<SkinPart> parts = skin.getParts();
        for (int i = 0; i < parts.size(); ++i) {
            ArmourerWorldHelper.loadSkinPartIntoWorld(world, parts.get(i), pos, direction, false);
        }
    }

    private static void loadSkinPartIntoWorld(World world, SkinPart partData, BlockPos pos, EnumFacing direction, boolean mirror) {
        ISkinPartType skinPart = partData.getPartType();
        IRectangle3D buildSpace = skinPart.getBuildingSpace();
        IPoint3D offset = skinPart.getOffset();
        SkinCubeData cubeData = partData.getCubeData();
        for (int i = 0; i < cubeData.getCubeCount(); ++i) {
            ICube blockData = cubeData.getCube(i);
            int meta = 0;
            for (int j = 0; j < partData.getMarkerBlocks().size(); ++j) {
                CubeMarkerData cmd = partData.getMarkerBlocks().get(j);
                byte[] loc = cubeData.getCubeLocation(i);
                if (!(cmd.x == loc[0] & cmd.y == loc[1] & cmd.z == loc[2])) continue;
                meta = cmd.meta;
                break;
            }
            BlockPos origin = new BlockPos(-offset.getX(), -offset.getY() + -buildSpace.getY(), offset.getZ());
            ArmourerWorldHelper.loadSkinBlockIntoWorld(world, pos, origin, blockData, direction, meta, cubeData, i, mirror);
        }
    }

    private static void loadSkinBlockIntoWorld(World world, BlockPos pos, BlockPos origin, ICube blockData, EnumFacing direction, int meta, SkinCubeData cubeData, int index, boolean mirror) {
        BlockPos target;
        byte[] loc = cubeData.getCubeLocation(index);
        int shiftX = -loc[0] - 1;
        int shiftY = loc[1] + 1;
        byte shiftZ = loc[2];
        if (mirror) {
            shiftX = loc[0];
        }
        if (world.func_180495_p(target = pos.func_177982_a(shiftX + origin.func_177958_n(), origin.func_177956_o() - shiftY, shiftZ + origin.func_177952_p())).func_177230_c() == ModBlocks.BOUNDING_BOX) {
            SyncWorldUpdater.addWorldUpdate(new AsyncWorldUpdateBlock(Blocks.field_150350_a.func_176223_P(), target, world));
        }
        Block targetBlock = blockData.getMinecraftBlock();
        IBlockState targetState = targetBlock.func_176203_a(meta);
        ModLogger.log(targetState);
        CubeColour cc = new CubeColour();
        for (int i = 0; i < 6; ++i) {
            byte[] c = cubeData.getCubeColour(index, i);
            byte paintType = cubeData.getCubePaintType(index, i);
            if (mirror) {
                if (i == 4) {
                    c = cubeData.getCubeColour(index, 5);
                    paintType = cubeData.getCubePaintType(index, 5);
                }
                if (i == 5) {
                    c = cubeData.getCubeColour(index, 4);
                    paintType = cubeData.getCubePaintType(index, 4);
                }
            }
            cc.setRed(c[0], i);
            cc.setGreen(c[1], i);
            cc.setBlue(c[2], i);
            cc.setPaintType(paintType, i);
        }
        TileEntityColourable colourable = new TileEntityColourable();
        colourable.setColour(cc);
        SyncWorldUpdater.addWorldUpdate(new AsyncWorldUpdateBlock(targetState, target, world).setTileEntity(colourable).setOnlyReplaceable(true).setDelay(index / 5));
    }

    public static void createBoundingBoxes(World world, BlockPos pos, BlockPos parentPos, ISkinType skinType, SkinProperties skinProps) {
        for (int i = 0; i < skinType.getSkinParts().size(); ++i) {
            ISkinPartType skinPart = skinType.getSkinParts().get(i);
            ArmourerWorldHelper.createBoundingBoxesForSkinPart(world, pos, parentPos, skinPart, skinProps);
        }
    }

    private static void createBoundingBoxesForSkinPart(World world, BlockPos pos, BlockPos parentPos, ISkinPartType skinPart, SkinProperties skinProps) {
        if (skinPart.isModelOverridden(skinProps)) {
            return;
        }
        IRectangle3D buildSpace = skinPart.getBuildingSpace();
        IRectangle3D guideSpace = skinPart.getGuideSpace();
        IPoint3D offset = skinPart.getOffset();
        if (guideSpace == null) {
            return;
        }
        for (int ix = 0; ix < guideSpace.getWidth(); ++ix) {
            for (int iy = 0; iy < guideSpace.getHeight(); ++iy) {
                for (int iz = 0; iz < guideSpace.getDepth(); ++iz) {
                    BlockPos target = pos.func_177982_a(ix + -offset.getX() + guideSpace.getX(), iy + -offset.getY() + guideSpace.getY() - buildSpace.getY(), iz + offset.getZ() + guideSpace.getZ());
                    ISkinPartType guidePart = skinPart;
                    byte guideX = (byte)ix;
                    byte guideY = (byte)iy;
                    byte guideZ = (byte)iz;
                    TileEntityBoundingBox te = new TileEntityBoundingBox(parentPos, guideX, guideY, guideZ, guidePart);
                    SyncWorldUpdater.addWorldUpdate(new AsyncWorldUpdateBlock(ModBlocks.BOUNDING_BOX.func_176223_P(), target, world).setTileEntity(te).setOnlyReplaceable(true));
                }
            }
        }
    }

    public static void removeBoundingBoxes(World world, BlockPos pos, ISkinType skinType) {
        for (int i = 0; i < skinType.getSkinParts().size(); ++i) {
            ISkinPartType skinPart = skinType.getSkinParts().get(i);
            ArmourerWorldHelper.removeBoundingBoxesForSkinPart(world, pos, skinPart);
        }
    }

    private static void removeBoundingBoxesForSkinPart(World world, BlockPos pos, ISkinPartType skinPart) {
        IRectangle3D buildSpace = skinPart.getBuildingSpace();
        IRectangle3D guideSpace = skinPart.getGuideSpace();
        IPoint3D offset = skinPart.getOffset();
        if (guideSpace == null) {
            return;
        }
        for (int ix = 0; ix < guideSpace.getWidth(); ++ix) {
            for (int iy = 0; iy < guideSpace.getHeight(); ++iy) {
                for (int iz = 0; iz < guideSpace.getDepth(); ++iz) {
                    BlockPos target = pos.func_177982_a(ix + -offset.getX() + guideSpace.getX(), iy + -offset.getY() + guideSpace.getY() - buildSpace.getY(), iz + offset.getZ() + guideSpace.getZ());
                    if (!world.func_175701_a(pos) || world.func_180495_p(target).func_177230_c() != ModBlocks.BOUNDING_BOX) continue;
                    SyncWorldUpdater.addWorldUpdate(new AsyncWorldUpdateBlock(Blocks.field_150350_a.func_176223_P(), target, world));
                }
            }
        }
    }

    public static void copySkinCubes(World world, BlockPos pos, ISkinPartType srcPart, ISkinPartType desPart, boolean mirror) throws SkinSaveException {
        SkinPart skinPart = ArmourerWorldHelper.saveArmourPart(world, srcPart, pos, null, false);
        if (skinPart != null) {
            skinPart.setSkinPart(desPart);
            ArmourerWorldHelper.loadSkinPartIntoWorld(world, skinPart, pos, null, mirror);
        }
    }

    public static int clearEquipmentCubes(World world, BlockPos pos, ISkinType skinType, SkinProperties skinProps) {
        return ArmourerWorldHelper.clearEquipmentCubes(world, pos, skinType, skinProps, null);
    }

    public static int clearMarkers(World world, BlockPos pos, ISkinType skinType, SkinProperties skinProps, ISkinPartType partType) {
        int blockCount = 0;
        for (int i = 0; i < skinType.getSkinParts().size(); ++i) {
            ISkinPartType skinPart = skinType.getSkinParts().get(i);
            if (partType != null && partType != skinPart) continue;
            if (skinType == SkinTypeRegistry.skinBlock) {
                boolean multiblock;
                if (skinPart == ((SkinBlock)SkinTypeRegistry.skinBlock).partBase & !(multiblock = SkinProperties.PROP_BLOCK_MULTIBLOCK.getValue(skinProps).booleanValue())) {
                    blockCount += ArmourerWorldHelper.clearMarkersForSkinPart(world, pos, skinPart);
                }
                if (!(skinPart == ((SkinBlock)SkinTypeRegistry.skinBlock).partMultiblock & multiblock)) continue;
                blockCount += ArmourerWorldHelper.clearMarkersForSkinPart(world, pos, skinPart);
                continue;
            }
            blockCount += ArmourerWorldHelper.clearMarkersForSkinPart(world, pos, skinPart);
        }
        return blockCount;
    }

    private static int clearMarkersForSkinPart(World world, BlockPos pos, ISkinPartType skinPart) {
        IRectangle3D buildSpace = skinPart.getBuildingSpace();
        IPoint3D offset = skinPart.getOffset();
        int blockCount = 0;
        for (int ix = 0; ix < buildSpace.getWidth(); ++ix) {
            for (int iy = 0; iy < buildSpace.getHeight(); ++iy) {
                for (int iz = 0; iz < buildSpace.getDepth(); ++iz) {
                    IBlockState state;
                    BlockPos target = pos.func_177982_a(ix + -offset.getX() + buildSpace.getX(), iy + -offset.getY(), iz + offset.getZ() + buildSpace.getZ());
                    if (!world.func_175701_a(target) || !CubeRegistry.INSTANCE.isBuildingBlock((state = world.func_180495_p(target)).func_177230_c())) continue;
                    IBlockState newState = state.func_177230_c().func_176203_a(0);
                    SyncWorldUpdater.addWorldUpdate(new AsyncWorldUpdateBlock(newState, target, world).setOnlyReplaceable(true));
                }
            }
        }
        return blockCount;
    }

    public static int clearEquipmentCubes(World world, BlockPos pos, ISkinType skinType, SkinProperties skinProps, ISkinPartType partType) {
        int blockCount = 0;
        for (int i = 0; i < skinType.getSkinParts().size(); ++i) {
            ISkinPartType skinPart = skinType.getSkinParts().get(i);
            if (partType != null && partType != skinPart) continue;
            if (skinType == SkinTypeRegistry.skinBlock) {
                boolean multiblock;
                if (skinPart == ((SkinBlock)SkinTypeRegistry.skinBlock).partBase & !(multiblock = SkinProperties.PROP_BLOCK_MULTIBLOCK.getValue(skinProps).booleanValue())) {
                    blockCount += ArmourerWorldHelper.clearEquipmentCubesForSkinPart(world, pos, skinPart);
                }
                if (!(skinPart == ((SkinBlock)SkinTypeRegistry.skinBlock).partMultiblock & multiblock)) continue;
                blockCount += ArmourerWorldHelper.clearEquipmentCubesForSkinPart(world, pos, skinPart);
                continue;
            }
            blockCount += ArmourerWorldHelper.clearEquipmentCubesForSkinPart(world, pos, skinPart);
        }
        return blockCount;
    }

    private static int clearEquipmentCubesForSkinPart(World world, BlockPos pos, ISkinPartType skinPart) {
        IRectangle3D buildSpace = skinPart.getBuildingSpace();
        IPoint3D offset = skinPart.getOffset();
        int blockCount = 0;
        for (int ix = 0; ix < buildSpace.getWidth(); ++ix) {
            for (int iy = 0; iy < buildSpace.getHeight(); ++iy) {
                for (int iz = 0; iz < buildSpace.getDepth(); ++iz) {
                    IBlockState state;
                    Block block;
                    BlockPos target = pos.func_177982_a(ix + -offset.getX() + buildSpace.getX(), iy + -offset.getY(), iz + offset.getZ() + buildSpace.getZ());
                    if (!world.func_175701_a(target) || !CubeRegistry.INSTANCE.isBuildingBlock(block = (state = world.func_180495_p(target)).func_177230_c())) continue;
                    SyncWorldUpdater.addWorldUpdate(new AsyncWorldUpdateBlock(Blocks.field_150350_a.func_176223_P(), target, world).setDelay(blockCount / 5));
                    ++blockCount;
                }
            }
        }
        return blockCount;
    }

    public static ArrayList<BlockPos> getListOfPaintableCubes(World world, BlockPos pos, ISkinType skinType) {
        ArrayList<BlockPos> blList = new ArrayList<BlockPos>();
        for (int i = 0; i < skinType.getSkinParts().size(); ++i) {
            ISkinPartType skinPart = skinType.getSkinParts().get(i);
            ArmourerWorldHelper.getBuildingCubesForPart(world, pos, skinPart, blList);
        }
        return blList;
    }

    private static void getBuildingCubesForPart(World world, BlockPos pos, ISkinPartType skinPart, ArrayList<BlockPos> blList) {
        IRectangle3D buildSpace = skinPart.getBuildingSpace();
        IPoint3D offset = skinPart.getOffset();
        for (int ix = 0; ix < buildSpace.getWidth(); ++ix) {
            for (int iy = 0; iy < buildSpace.getHeight(); ++iy) {
                for (int iz = 0; iz < buildSpace.getDepth(); ++iz) {
                    IBlockState state;
                    BlockPos target = pos.func_177982_a(ix + -offset.getX() + buildSpace.getX(), iy + -offset.getY(), iz + offset.getZ() + buildSpace.getZ());
                    if (!world.func_175701_a(target) || !CubeRegistry.INSTANCE.isBuildingBlock((state = world.func_180495_p(target)).func_177230_c())) continue;
                    blList.add(new BlockPos(target.func_177958_n(), target.func_177956_o(), target.func_177952_p()));
                }
            }
        }
    }

    private static int getNumberOfCubesInPart(World world, BlockPos pos, ISkinPartType skinPart) {
        IRectangle3D buildSpace = skinPart.getBuildingSpace();
        IPoint3D offset = skinPart.getOffset();
        int cubeCount = 0;
        for (int ix = 0; ix < buildSpace.getWidth(); ++ix) {
            for (int iy = 0; iy < buildSpace.getHeight(); ++iy) {
                for (int iz = 0; iz < buildSpace.getDepth(); ++iz) {
                    IBlockState blockState;
                    BlockPos target = pos.func_177982_a(ix + -offset.getX() + buildSpace.getX(), iy + -offset.getY(), iz + offset.getZ() + buildSpace.getZ());
                    if (!world.func_175701_a(target) || !CubeRegistry.INSTANCE.isBuildingBlock((blockState = world.func_180495_p(target)).func_177230_c())) continue;
                    ++cubeCount;
                }
            }
        }
        return cubeCount;
    }
}

