/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.tileentities;

import com.mojang.authlib.GameProfile;
import moe.plushie.armourers_workshop.client.gui.mannequin.GuiMannequin;
import moe.plushie.armourers_workshop.common.GameProfileCache;
import moe.plushie.armourers_workshop.common.capability.wardrobe.ExtraColours;
import moe.plushie.armourers_workshop.common.data.type.BipedRotations;
import moe.plushie.armourers_workshop.common.data.type.TextureType;
import moe.plushie.armourers_workshop.common.inventory.ContainerMannequin;
import moe.plushie.armourers_workshop.common.inventory.IGuiFactory;
import moe.plushie.armourers_workshop.common.tileentities.AbstractTileEntityInventory;
import moe.plushie.armourers_workshop.common.tileentities.property.TileProperty;
import moe.plushie.armourers_workshop.common.world.AsyncWorldUpdateGameProfileDownload;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMannequin
extends AbstractTileEntityInventory
implements GameProfileCache.IGameProfileCallback,
IGuiFactory {
    public static final int CONS_OFFSET_MAX = 3;
    public static final int CONS_INVENTORY_ROW_SIZE = 7;
    public static final int CONS_INVENTORY_ROWS_COUNT = 5;
    public static final int CONS_INVENTORY_SIZE = 35;
    public final TileProperty<GameProfile> PROP_OWNER = new TileProperty<Object>(this, "owner", GameProfile.class, null);
    public final TileProperty<Integer> PROP_ROTATION = new TileProperty<Integer>(this, "rotation", Integer.class, 0);
    public final TileProperty<Boolean> PROP_DOLL = new TileProperty<Boolean>(this, "doll", Boolean.class, false);
    public final TileProperty<ExtraColours> PROP_EXTRA_COLOURS = new TileProperty<Object>(this, "extra_colours", ExtraColours.class, null);
    public final TileProperty<Float> PROP_OFFSET_X = new TileProperty<Float>(this, "offset_x", Float.class, Float.valueOf(0.0f));
    public final TileProperty<Float> PROP_OFFSET_Y = new TileProperty<Float>(this, "offset_y", Float.class, Float.valueOf(0.0f));
    public final TileProperty<Float> PROP_OFFSET_Z = new TileProperty<Float>(this, "offset_z", Float.class, Float.valueOf(0.0f));
    public final TileProperty<Boolean> PROP_RENDER_EXTRAS = new TileProperty<Boolean>(this, "render_extras", Boolean.class, true);
    public final TileProperty<Boolean> PROP_FLYING = new TileProperty<Boolean>(this, "flying", Boolean.class, false);
    public final TileProperty<Boolean> PROP_VISIBLE = new TileProperty<Boolean>(this, "visible", Boolean.class, true);
    public final TileProperty<TextureType> PROP_TEXTURE_TYPE = new TileProperty<TextureType>(this, "texture_type", TextureType.class, TextureType.USER);
    public final TileProperty<String> PROP_IMAGE_URL = new TileProperty<Object>(this, "image_url", String.class, null);
    public final TileProperty<BipedRotations> PROP_BIPED_ROTATIONS = new TileProperty<Object>(this, "image_url", BipedRotations.class, null);
    public final TileProperty<Boolean> PROP_NOCLIP = new TileProperty<Boolean>(this, "noclip", Boolean.class, false);

    public TileEntityMannequin(boolean isDoll) {
        super(35);
        this.PROP_DOLL.set(isDoll);
        this.PROP_BIPED_ROTATIONS.set(new BipedRotations());
        this.PROP_EXTRA_COLOURS.set(ExtraColours.EMPTY_COLOUR);
    }

    public TileEntityMannequin() {
        this(false);
    }

    @Override
    public void onPropertyChanged(TileProperty<?> property) {
        if (property == this.PROP_OWNER) {
            AsyncWorldUpdateGameProfileDownload profileDownload = new AsyncWorldUpdateGameProfileDownload(this.func_174877_v(), this.func_145831_w());
            GameProfileCache.getGameProfile(this.PROP_OWNER.get(), profileDownload);
        }
        super.onPropertyChanged(property);
    }

    @Override
    public void func_70299_a(int i, ItemStack itemstack) {
        super.func_70299_a(i, itemstack);
        if (this.func_145831_w().field_72995_K) {
            // empty if block
        }
        this.syncWithClients();
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        return compound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.func_145839_a(compound);
        this.dirtySync();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = new AxisAlignedBB(-1.0, 0.0, -1.0, 2.0, 3.0, 2.0);
        return bb.func_186670_a(this.func_174877_v());
    }

    @Override
    public String func_70005_c_() {
        return "mannequin";
    }

    @Override
    public void profileDownloaded(GameProfile gameProfile) {
        ModLogger.log("got profile " + gameProfile);
        this.PROP_OWNER.loadType(gameProfile);
        this.dirtySync();
    }

    @Override
    public Container getServerGuiElement(EntityPlayer player, World world, BlockPos pos) {
        return new ContainerMannequin(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(EntityPlayer player, World world, BlockPos pos) {
        return new GuiMannequin(player.field_71071_by, this);
    }
}

