/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.tileentities;

import java.awt.Color;
import moe.plushie.armourers_workshop.api.common.painting.IPaintType;
import moe.plushie.armourers_workshop.api.common.painting.IPantable;
import moe.plushie.armourers_workshop.api.common.skin.cubes.ICubeColour;
import moe.plushie.armourers_workshop.common.painting.PaintTypeRegistry;
import moe.plushie.armourers_workshop.common.skin.cubes.CubeColour;
import moe.plushie.armourers_workshop.common.tileentities.ModTileEntity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityColourable
extends ModTileEntity
implements IPantable {
    private ICubeColour colour;

    public TileEntityColourable() {
        this.colour = new CubeColour();
    }

    public TileEntityColourable(int colour) {
        this.colour = new CubeColour(colour);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.colour.readFromNBT(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.colour.writeToNBT(compound);
        return compound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 5, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        return compound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        this.syncWithClients();
    }

    @Override
    public void setColour(int colour) {
        this.colour.setColour(colour);
        this.dirtySync();
    }

    @Override
    public void setColour(int colour, int side) {
        this.colour.setColour(colour, side);
        this.dirtySync();
    }

    @Override
    public void setColour(byte[] rgb, int side) {
        this.colour.setRed(rgb[0], side);
        this.colour.setGreen(rgb[1], side);
        this.colour.setBlue(rgb[2], side);
        this.dirtySync();
    }

    @Override
    public void setColour(ICubeColour colour) {
        this.colour = colour;
    }

    @Override
    public int getColour(int side) {
        Color saveColour = new Color(this.colour.getRed(side) & 0xFF, this.colour.getGreen(side) & 0xFF, this.colour.getBlue(side) & 0xFF, 255);
        return saveColour.getRGB();
    }

    @Override
    public void setPaintType(IPaintType paintType, int side) {
        this.colour.setPaintType((byte)paintType.getId(), side);
        this.dirtySync();
    }

    @Override
    public IPaintType getPaintType(int side) {
        return PaintTypeRegistry.getInstance().getPaintTypeFormByte(this.colour.getPaintType(side));
    }

    @Override
    public ICubeColour getColour() {
        return this.colour;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v());
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 2048.0;
    }
}

