/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.tileentities;

import java.awt.Point;
import moe.plushie.armourers_workshop.api.common.painting.IPaintType;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinPartType;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinPartTypeTextured;
import moe.plushie.armourers_workshop.client.config.ConfigHandlerClient;
import moe.plushie.armourers_workshop.common.painting.PaintTypeRegistry;
import moe.plushie.armourers_workshop.common.skin.SkinTextureHelper;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import moe.plushie.armourers_workshop.common.tileentities.ModTileEntity;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityArmourer;
import moe.plushie.armourers_workshop.utils.NBTHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBoundingBox
extends ModTileEntity {
    private static final String TAG_PARENT = "parent";
    private static final String TAG_GUIDE_X = "guideX";
    private static final String TAG_GUIDE_Y = "guideY";
    private static final String TAG_GUIDE_Z = "guideZ";
    private static final String TAG_SKIN_PART = "skinPart";
    private BlockPos parent;
    private byte guideX;
    private byte guideY;
    private byte guideZ;
    private ISkinPartType skinPart;
    private static final AxisAlignedBB blockBounds = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public TileEntityBoundingBox() {
        this.setParent(null, (byte)0, (byte)0, (byte)0, null);
    }

    public TileEntityBoundingBox(BlockPos parent, byte guideX, byte guideY, byte guideZ, ISkinPartType skinPart) {
        this.setParent(parent, guideX, guideY, guideZ, skinPart);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.parent = NBTHelper.readBlockPosFromNBT(compound, TAG_PARENT);
        this.guideX = compound.func_74771_c(TAG_GUIDE_X);
        this.guideY = compound.func_74771_c(TAG_GUIDE_Y);
        this.guideZ = compound.func_74771_c(TAG_GUIDE_Z);
        this.skinPart = SkinTypeRegistry.INSTANCE.getSkinPartFromRegistryName(compound.func_74779_i(TAG_SKIN_PART));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTHelper.writeBlockPosToNBT(compound, TAG_PARENT, this.parent);
        compound.func_74774_a(TAG_GUIDE_X, this.guideX);
        compound.func_74774_a(TAG_GUIDE_Y, this.guideY);
        compound.func_74774_a(TAG_GUIDE_Z, this.guideZ);
        if (this.skinPart != null) {
            compound.func_74778_a(TAG_SKIN_PART, this.skinPart.getRegistryName());
        }
        return compound;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 5, compound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        this.syncWithClients();
    }

    public TileEntityArmourer getParent() {
        TileEntity te;
        if (this.parent != null && (te = this.func_145831_w().func_175625_s(this.parent)) != null && te instanceof TileEntityArmourer) {
            return (TileEntityArmourer)te;
        }
        return null;
    }

    public boolean isParentValid() {
        TileEntity te;
        return this.parent != null && (te = this.func_145831_w().func_175625_s(this.parent)) != null && te instanceof TileEntityArmourer;
    }

    public ISkinPartType getSkinPart() {
        return this.skinPart;
    }

    public void setParent(BlockPos parent, byte guideX, byte guideY, byte guideZ, ISkinPartType skinPart) {
        this.parent = parent;
        this.guideX = guideX;
        this.guideY = guideY;
        this.guideZ = guideZ;
        this.skinPart = skinPart;
        this.func_70296_d();
    }

    public byte getGuideX() {
        return this.guideX;
    }

    public byte getGuideY() {
        return this.guideY;
    }

    public byte getGuideZ() {
        return this.guideZ;
    }

    public boolean isPaintableSide(int side) {
        EnumFacing sideBlock = EnumFacing.func_82600_a((int)side);
        return this.func_145831_w().func_180495_p(this.func_174877_v().func_177972_a(sideBlock)).func_177230_c() != this.func_145838_q();
    }

    public IPaintType getPaintType(EnumFacing facing) {
        if (this.isParentValid() && this.skinPart instanceof ISkinPartTypeTextured) {
            Point texPoint = SkinTextureHelper.getTextureLocationFromWorldBlock(this, facing);
            int colour = this.getParent().getPaintData(texPoint.x, texPoint.y);
            return PaintTypeRegistry.getInstance().getPaintTypeFromColour(colour);
        }
        return PaintTypeRegistry.PAINT_TYPE_NORMAL;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return blockBounds.func_186670_a(this.func_174877_v());
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return ConfigHandlerClient.renderDistanceBlockSkin;
    }
}

