/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.skin.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinIdentifier;
import moe.plushie.armourers_workshop.common.config.ConfigHandler;
import moe.plushie.armourers_workshop.common.data.type.ExpiringHashMap;
import moe.plushie.armourers_workshop.common.skin.cache.CommonSkinCache;
import moe.plushie.armourers_workshop.common.skin.cache.SkinRequestMessage;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.utils.SkinIOUtils;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class SkinCacheLocalDatabase
implements RemovalListener<Integer, Skin> {
    private final LoadingCache<Integer, Skin> skinCache;
    private final Queue<SkinRequestMessage> skinLoadQueue;
    private final Object skinLoadQueueLock = new Object();
    private final ExpiringHashMap.IExpiringMapCallback<Skin> callback;

    public SkinCacheLocalDatabase(ExpiringHashMap.IExpiringMapCallback<Skin> callback) {
        this.callback = callback;
        CacheBuilder builder = CacheBuilder.newBuilder();
        builder.removalListener((RemovalListener)this);
        if (ConfigHandler.skinCacheExpireTime > 1) {
            builder.expireAfterAccess((long)ConfigHandler.skinCacheExpireTime, TimeUnit.SECONDS);
        }
        if (ConfigHandler.skinCacheMaxSize > 1) {
            builder.maximumSize((long)ConfigHandler.skinCacheMaxSize);
        }
        this.skinCache = builder.build((CacheLoader)new SkinLoader());
        this.skinLoadQueue = new LinkedList<SkinRequestMessage>();
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSkinLoading() {
        Object object = this.skinLoadQueueLock;
        synchronized (object) {
            if (!this.skinLoadQueue.isEmpty()) {
                SkinRequestMessage requestMessage = this.skinLoadQueue.remove();
                Skin skin = null;
                try {
                    skin = (Skin)this.skinCache.get((Object)requestMessage.getSkinIdentifier().getSkinLocalId());
                }
                catch (Exception e) {
                    CommonSkinCache.INSTANCE.onSkinLoaded(null, requestMessage);
                    e.printStackTrace();
                }
                if (skin != null) {
                    CommonSkinCache.INSTANCE.onSkinLoaded(skin, requestMessage);
                }
            }
        }
    }

    public Skin get(ISkinIdentifier identifier, boolean softLoad) {
        return this.get(new SkinRequestMessage(identifier, null), softLoad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Skin get(SkinRequestMessage requestMessage, boolean softLoad) {
        block7: {
            int skinId = requestMessage.getSkinIdentifier().getSkinLocalId();
            if (!softLoad) {
                try {
                    return (Skin)this.skinCache.get((Object)skinId);
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    break block7;
                }
            }
            Skin skin = (Skin)this.skinCache.getIfPresent((Object)skinId);
            if (skin != null) {
                return skin;
            }
            Object object = this.skinLoadQueueLock;
            synchronized (object) {
                this.skinLoadQueue.add(requestMessage);
            }
        }
        return null;
    }

    public void add(Skin skin) {
        this.addSkinDataToCache(skin, skin.lightHash());
    }

    public int size() {
        return this.skinCache.asMap().size();
    }

    public void clear() {
        this.skinCache.invalidateAll();
    }

    public void onRemoval(RemovalNotification<Integer, Skin> notification) {
        if (this.callback != null) {
            this.callback.itemExpired((Skin)notification.getValue());
        }
    }

    private void addSkinDataToCache(Skin skin, int skinId) {
        if (skin == null) {
            return;
        }
        if (!this.haveSkinOnDisk(skinId)) {
            this.saveSkinToDisk(skin);
        }
        this.skinCache.asMap().putIfAbsent(skinId, skin);
    }

    private void saveSkinToDisk(Skin skin) {
        File file = new File(SkinIOUtils.getSkinDatabaseDirectory(), String.valueOf(skin.hashCode()));
        SkinIOUtils.saveSkinToFile(file, skin);
    }

    private boolean haveSkinOnDisk(int equipmentId) {
        File file = new File(SkinIOUtils.getSkinDatabaseDirectory(), String.valueOf(equipmentId));
        return file.exists();
    }

    private Skin loadSkinFromDisk(int equipmentId) {
        File file = new File(SkinIOUtils.getSkinDatabaseDirectory(), String.valueOf(equipmentId));
        return SkinIOUtils.loadSkinFromFile(file);
    }

    private class SkinLoader
    extends CacheLoader<Integer, Skin> {
        private SkinLoader() {
        }

        public Skin load(Integer key) throws Exception {
            return this.loadSkin(key);
        }

        private Skin loadSkin(int skinId) throws IOException {
            if (SkinCacheLocalDatabase.this.haveSkinOnDisk(skinId)) {
                Skin skin = SkinCacheLocalDatabase.this.loadSkinFromDisk(skinId);
                if (skin != null) {
                    SkinCacheLocalDatabase.this.addSkinDataToCache(skin, skinId);
                    if (skin.hashCode() != skinId) {
                        SkinCacheLocalDatabase.this.addSkinDataToCache(skin, skin.hashCode());
                    }
                    return skin;
                }
                throw new IOException(String.format("Failed to load skin id:%s from disk.", String.valueOf(skinId)));
            }
            throw new IOException(String.format("The skin id:%s was not found on the disk.", String.valueOf(skinId)));
        }
    }
}

