/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.network.messages.server;

import io.netty.buffer.ByteBuf;
import moe.plushie.armourers_workshop.client.model.bake.ModelBakery;
import moe.plushie.armourers_workshop.client.skin.cache.ClientSkinCache;
import moe.plushie.armourers_workshop.common.data.serialize.SkinIdentifierSerializer;
import moe.plushie.armourers_workshop.common.network.ByteBufHelper;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinIdentifier;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageServerSendSkinData
implements IMessage,
IMessageHandler<MessageServerSendSkinData, IMessage> {
    private SkinIdentifier skinIdentifierRequested;
    private SkinIdentifier skinIdentifierUpdated;
    private Skin skin;

    public MessageServerSendSkinData() {
    }

    public MessageServerSendSkinData(SkinIdentifier skinIdentifierRequested, SkinIdentifier skinIdentifierUpdated, Skin skin) {
        this.skinIdentifierRequested = skinIdentifierRequested;
        this.skinIdentifierUpdated = skinIdentifierUpdated;
        this.skin = skin;
    }

    public void toBytes(ByteBuf buf) {
        SkinIdentifierSerializer.writeToByteBuf(this.skinIdentifierRequested, buf);
        SkinIdentifierSerializer.writeToByteBuf(this.skinIdentifierUpdated, buf);
        buf.writeBoolean(this.skin != null);
        if (this.skin != null) {
            ByteBufHelper.writeSkinToByteBuf(buf, this.skin);
        }
    }

    public void fromBytes(ByteBuf buf) {
        Thread t = new Thread((Runnable)new SkinDownloadThread(buf), "Skin download thread.");
        this.handleDownload(t);
    }

    public IMessage onMessage(MessageServerSendSkinData message, MessageContext ctx) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleDownload(Thread downloadThread) {
        ModelBakery.INSTANCE.handleModelDownload(downloadThread);
    }

    public class SkinDownloadThread
    implements Runnable {
        private ByteBuf buf;

        public SkinDownloadThread(ByteBuf buf) {
            this.buf = buf.retain();
        }

        @Override
        public void run() {
            SkinIdentifier skinIdentifierRequested = SkinIdentifierSerializer.readFromByteBuf(this.buf);
            SkinIdentifier skinIdentifierUpdated = SkinIdentifierSerializer.readFromByteBuf(this.buf);
            Skin skin = null;
            if (this.buf.readBoolean()) {
                skin = ByteBufHelper.readSkinFromByteBuf(this.buf);
            }
            this.sendSkinForBaking(skin, skinIdentifierRequested, skinIdentifierUpdated);
            this.buf.release();
        }

        @SideOnly(value=Side.CLIENT)
        private void sendSkinForBaking(Skin skin, SkinIdentifier skinIdentifierRequested, SkinIdentifier skinIdentifierUpdated) {
            ModelBakery.INSTANCE.receivedUnbakedModel(skin, skinIdentifierRequested, skinIdentifierUpdated, ClientSkinCache.INSTANCE);
        }
    }
}

