/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.network.messages.server;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.common.library.LibraryFile;
import moe.plushie.armourers_workshop.common.library.LibraryFileType;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageServerLibraryFileList
implements IMessage,
IMessageHandler<MessageServerLibraryFileList, IMessage> {
    ArrayList<LibraryFile> fileList;
    LibraryFileType listType;

    public MessageServerLibraryFileList() {
    }

    public MessageServerLibraryFileList(ArrayList<LibraryFile> fileList, LibraryFileType listType) {
        this.fileList = fileList;
        this.listType = listType;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.fileList.size());
        for (int i = 0; i < this.fileList.size(); ++i) {
            this.fileList.get(i).writeToByteBuf(buf);
        }
        buf.writeByte(this.listType.ordinal());
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.fileList = new ArrayList();
        for (int i = 0; i < size; ++i) {
            this.fileList.add(LibraryFile.readFromByteBuf(buf));
        }
        this.listType = LibraryFileType.values()[buf.readByte()];
    }

    public IMessage onMessage(MessageServerLibraryFileList message, MessageContext ctx) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        Container container = player.field_71070_bA;
        ModLogger.log("got file list type " + (Object)((Object)message.listType));
        ArmourersWorkshop.getProxy().libraryManager.setFileList(message.fileList, message.listType);
        return null;
    }
}

