/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.network.messages.client;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.common.inventory.ModTileContainer;
import moe.plushie.armourers_workshop.common.tileentities.ModTileEntity;
import moe.plushie.armourers_workshop.common.tileentities.property.TileProperty;
import moe.plushie.armourers_workshop.common.tileentities.property.TilePropertyManager;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageClientGuiUpdateTileProperties
implements IMessage,
IMessageHandler<MessageClientGuiUpdateTileProperties, IMessage> {
    private ArrayList<TileProperty<?>> propertiesList;
    private NBTTagCompound compound;

    public MessageClientGuiUpdateTileProperties() {
    }

    public MessageClientGuiUpdateTileProperties(ArrayList<TileProperty<?>> propertiesList) {
        this.propertiesList = propertiesList;
    }

    public MessageClientGuiUpdateTileProperties(TileProperty<?> ... properties) {
        this.propertiesList = new ArrayList();
        for (TileProperty<?> property : properties) {
            this.propertiesList.add(property);
        }
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound compound = new NBTTagCompound();
        for (TileProperty<?> property : this.propertiesList) {
            TilePropertyManager.INSTANCE.writePropToCompound(property, compound);
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)compound);
    }

    public void fromBytes(ByteBuf buf) {
        this.compound = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public IMessage onMessage(MessageClientGuiUpdateTileProperties message, MessageContext ctx) {
        Object tileEntity;
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        if (player == null) {
            return null;
        }
        Container container = player.field_71070_bA;
        if (container != null && container instanceof ModTileContainer && (tileEntity = ((ModTileContainer)container).getTileEntity()) instanceof ModTileEntity) {
            ModTileEntity modTile = (ModTileEntity)tileEntity;
            modTile.disableSync();
            modTile.readPropsFromCompound(message.compound);
            modTile.enableSync();
            modTile.dirtySync();
        }
        return null;
    }
}

