/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.network;

import java.util.ArrayList;
import java.util.HashMap;
import moe.plushie.armourers_workshop.common.config.ConfigHandler;
import moe.plushie.armourers_workshop.common.inventory.ContainerSkinLibrary;
import moe.plushie.armourers_workshop.common.network.ByteBufHelper;
import moe.plushie.armourers_workshop.common.network.PacketHandler;
import moe.plushie.armourers_workshop.common.network.messages.client.MessageClientSkinPart;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinIdentifier;
import moe.plushie.armourers_workshop.common.tileentities.TileEntitySkinLibrary;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.ArrayUtils;

public final class SkinUploadHelper {
    private static final HashMap<Integer, byte[]> unfinishedSkins = new HashMap();
    private static final int MAX_PACKET_SIZE = 30000;

    public static void uploadSkinToServer(Skin skin) {
        int i;
        if (!ConfigHandler.allowUploadingSkins) {
            return;
        }
        skin.requestId = new SkinIdentifier(skin);
        ModLogger.log("Uploading skin to server: " + skin);
        byte[] skinData = ByteBufHelper.convertSkinToByteArray(skin);
        ArrayList<MessageClientSkinPart> packetQueue = new ArrayList<MessageClientSkinPart>();
        int packetsNeeded = (int)Math.ceil((double)skinData.length / 30000.0);
        int bytesLeftToSend = skinData.length;
        int bytesSent = 0;
        for (i = 0; i < packetsNeeded; ++i) {
            boolean lastPacket = i == packetsNeeded - 1;
            byte[] messageData = lastPacket ? new byte[bytesLeftToSend] : new byte[30000];
            System.arraycopy(skinData, bytesSent, messageData, 0, messageData.length);
            MessageClientSkinPart skinMessage = new MessageClientSkinPart(skin.lightHash(), (byte)i, messageData);
            packetQueue.add(skinMessage);
            bytesLeftToSend -= messageData.length;
            bytesSent += messageData.length;
        }
        for (i = 0; i < packetQueue.size(); ++i) {
            PacketHandler.networkWrapper.sendToServer((IMessage)packetQueue.get(i));
        }
    }

    public static void gotSkinPartFromClient(int skinId, byte packetId, byte[] skinData, EntityPlayerMP player) {
        boolean lastPacket = skinData.length < 30000;
        byte[] oldSkinData = unfinishedSkins.get(skinId);
        byte[] newSkinData = null;
        if (oldSkinData != null) {
            newSkinData = ArrayUtils.addAll((byte[])oldSkinData, (byte[])skinData);
            unfinishedSkins.remove(skinId);
        } else {
            newSkinData = skinData;
        }
        if (!lastPacket) {
            unfinishedSkins.put(skinId, newSkinData);
        } else {
            Skin skin = ByteBufHelper.convertByteArrayToSkin(newSkinData);
            ModLogger.log("Downloaded skin " + skin + " from client " + player);
            Container container = player.field_71070_bA;
            if (!ConfigHandler.allowUploadingSkins) {
                return;
            }
            if (container != null && container instanceof ContainerSkinLibrary) {
                TileEntitySkinLibrary te = (TileEntitySkinLibrary)((ContainerSkinLibrary)container).getTileEntity();
                te.loadClientSkin(skin, player);
            }
        }
    }
}

