/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.library.global.permission;

import java.util.EnumSet;

public final class PermissionSystem {
    public final PermissionGroup groupNoLogin;
    public final PermissionGroup groupUser;
    public final PermissionGroup groupUserBanned;
    public final PermissionGroup groupUserBannedUploads;
    public final PermissionGroup groupUserBannedRatings;
    public final PermissionGroup groupUserBannedReporting;
    public final PermissionGroup groupUserBannedComment;
    public final PermissionGroup groupMod;
    public final PermissionGroup groupAdmin;

    public PermissionSystem() {
        EnumSet<PlushieAction> actionsNoLogin = EnumSet.noneOf(PlushieAction.class);
        EnumSet<PlushieAction> actionsUser = EnumSet.noneOf(PlushieAction.class);
        EnumSet<PlushieAction> actionsUserBanned = EnumSet.noneOf(PlushieAction.class);
        EnumSet<PlushieAction> actionsBannedUploads = EnumSet.noneOf(PlushieAction.class);
        EnumSet<PlushieAction> actionsBannedRatings = EnumSet.noneOf(PlushieAction.class);
        EnumSet<PlushieAction> actionsBannedReporting = EnumSet.noneOf(PlushieAction.class);
        EnumSet<PlushieAction> actionsBannedComment = EnumSet.noneOf(PlushieAction.class);
        EnumSet<PlushieAction> actionsMod = EnumSet.noneOf(PlushieAction.class);
        EnumSet<PlushieAction> actionsAdmin = EnumSet.noneOf(PlushieAction.class);
        actionsNoLogin.add(PlushieAction.SKIN_DOWNLOAD);
        actionsNoLogin.add(PlushieAction.USER_INFO);
        actionsNoLogin.add(PlushieAction.SKIN_SEARCH);
        actionsNoLogin.add(PlushieAction.SKIN_LIST_USER);
        actionsNoLogin.add(PlushieAction.BETA_JOIN);
        actionsNoLogin.add(PlushieAction.BETA_CHECK);
        actionsNoLogin.add(PlushieAction.SERVER_VIEW_STATS);
        actionsNoLogin.add(PlushieAction.GET_SKIN_INFO);
        actionsUser.addAll(actionsNoLogin);
        actionsUser.add(PlushieAction.SKIN_UPLOAD);
        actionsUser.add(PlushieAction.SKIN_RATE);
        actionsUser.add(PlushieAction.SKIN_REPORT);
        actionsUser.add(PlushieAction.SKIN_OWNER_DELETE);
        actionsUser.add(PlushieAction.SKIN_OWNER_EDIT);
        actionsUser.add(PlushieAction.SKIN_COMMENT_CREATE);
        actionsUser.add(PlushieAction.SKIN_COMMENT_OWNER_DELETE);
        actionsUser.add(PlushieAction.SKIN_COMMENT_OWNER_EDIT);
        actionsUser.add(PlushieAction.SKIN_GET_RATED);
        actionsUserBanned.addAll(actionsUser);
        actionsUserBanned.remove((Object)PlushieAction.SKIN_UPLOAD);
        actionsUserBanned.remove((Object)PlushieAction.SKIN_RATE);
        actionsUserBanned.remove((Object)PlushieAction.SKIN_REPORT);
        actionsUserBanned.remove((Object)PlushieAction.SKIN_OWNER_EDIT);
        actionsUserBanned.remove((Object)PlushieAction.SKIN_COMMENT_CREATE);
        actionsUserBanned.remove((Object)PlushieAction.SKIN_COMMENT_OWNER_EDIT);
        actionsBannedUploads.addAll(actionsUser);
        actionsBannedUploads.remove((Object)PlushieAction.SKIN_UPLOAD);
        actionsBannedRatings.addAll(actionsUser);
        actionsBannedRatings.remove((Object)PlushieAction.SKIN_RATE);
        actionsBannedReporting.addAll(actionsUser);
        actionsBannedReporting.remove((Object)PlushieAction.SKIN_REPORT);
        actionsBannedComment.addAll(actionsUser);
        actionsBannedComment.remove((Object)PlushieAction.SKIN_COMMENT_CREATE);
        actionsBannedComment.remove((Object)PlushieAction.SKIN_COMMENT_OWNER_EDIT);
        actionsMod.addAll(actionsUser);
        actionsMod.add(PlushieAction.SKIN_MOD_EDIT);
        actionsMod.add(PlushieAction.SKIN_MOD_DELETE);
        actionsMod.add(PlushieAction.SKIN_COMMENT_MOD_DELETE);
        actionsMod.add(PlushieAction.SKIN_COMMENT_MOD_EDIT);
        actionsMod.add(PlushieAction.FLAG_GET_LIST);
        actionsMod.add(PlushieAction.FLAG_DELETE);
        actionsMod.add(PlushieAction.USER_BAN_TEMP);
        actionsMod.add(PlushieAction.USER_BAN_PERM);
        actionsMod.add(PlushieAction.GET_REPORT_LIST);
        actionsAdmin.addAll(EnumSet.allOf(PlushieAction.class));
        this.groupNoLogin = new PermissionGroup("no login", (EnumSet<PlushieAction>)actionsNoLogin.clone());
        this.groupUser = new PermissionGroup("user", (EnumSet<PlushieAction>)actionsUser.clone());
        this.groupUserBanned = new PermissionGroup("user", (EnumSet<PlushieAction>)actionsUserBanned.clone());
        this.groupUserBannedUploads = new PermissionGroup("user", (EnumSet<PlushieAction>)actionsBannedUploads.clone());
        this.groupUserBannedRatings = new PermissionGroup("user", (EnumSet<PlushieAction>)actionsBannedRatings.clone());
        this.groupUserBannedReporting = new PermissionGroup("user", (EnumSet<PlushieAction>)actionsBannedReporting.clone());
        this.groupUserBannedComment = new PermissionGroup("user", (EnumSet<PlushieAction>)actionsBannedComment.clone());
        this.groupMod = new PermissionGroup("mod", (EnumSet<PlushieAction>)actionsMod.clone());
        this.groupAdmin = new PermissionGroup("admin", (EnumSet<PlushieAction>)actionsAdmin.clone());
    }

    public PermissionGroup getPermissionGroup(int id) {
        switch (id) {
            case 0: {
                return this.groupUser;
            }
            case 1: {
                return this.groupMod;
            }
            case 10: {
                return this.groupUserBanned;
            }
            case 11: {
                return this.groupUserBannedUploads;
            }
            case 12: {
                return this.groupUserBannedRatings;
            }
            case 13: {
                return this.groupUserBannedReporting;
            }
            case 14: {
                return this.groupUserBannedComment;
            }
            case 255: {
                return this.groupAdmin;
            }
        }
        return this.groupNoLogin;
    }

    public static class AuthenticationException
    extends Exception {
    }

    public static class InsufficientPermissionsException
    extends Exception {
        private final PlushieAction plushieAction;

        public InsufficientPermissionsException(PlushieAction plushieAction) {
            this.plushieAction = plushieAction;
        }

        public PlushieAction getAction() {
            return this.plushieAction;
        }
    }

    public static class PermissionGroup {
        private final String name;
        private final EnumSet<PlushieAction> actions;

        public PermissionGroup(String name, EnumSet<PlushieAction> actions) {
            this.name = name;
            this.actions = EnumSet.noneOf(PlushieAction.class);
            this.actions.addAll(actions);
        }

        public String getName() {
            return this.name;
        }

        public boolean havePermission(PlushieAction action) {
            return this.actions.contains((Object)action);
        }
    }

    public static enum PlushieAction {
        BETA_JOIN,
        BETA_CHECK,
        SKIN_SEARCH,
        SKIN_LIST_USER,
        SKIN_DOWNLOAD,
        USER_INFO,
        SERVER_VIEW_STATS,
        GET_SKIN_INFO,
        SKIN_UPLOAD,
        SKIN_RATE,
        SKIN_GET_RATED,
        SKIN_REPORT,
        SKIN_OWNER_DELETE,
        SKIN_OWNER_EDIT,
        SKIN_COMMENT_CREATE,
        SKIN_COMMENT_OWNER_DELETE,
        SKIN_COMMENT_OWNER_EDIT,
        GET_REPORT_LIST,
        SKIN_MOD_DELETE,
        SKIN_MOD_EDIT,
        SKIN_COMMENT_MOD_DELETE,
        SKIN_COMMENT_MOD_EDIT,
        FLAG_GET_LIST,
        FLAG_DELETE,
        USER_BAN_TEMP,
        USER_BAN_PERM,
        USER_GROUP_CHANGE;

    }
}

