/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.inventory.slot;

import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.common.init.items.ItemSkin;
import moe.plushie.armourers_workshop.common.inventory.MannequinSlotType;
import moe.plushie.armourers_workshop.common.inventory.slot.SlotHidable;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SlotMannequin
extends SlotHidable {
    private MannequinSlotType slotType;

    public SlotMannequin(MannequinSlotType slotType, IInventory inventory, int slotIndex, int xDisplayPosition, int yDisplayPosition) {
        super(inventory, slotIndex, xDisplayPosition, yDisplayPosition);
        this.slotType = slotType;
    }

    public boolean func_75214_a(ItemStack stack) {
        Item item = stack.func_77973_b();
        switch (this.slotType) {
            case HEAD: {
                if (item instanceof ItemBlock) {
                    return true;
                }
                if (!(item instanceof ItemSkin) || ((ItemSkin)item).getSkinType(stack) != SkinTypeRegistry.skinHead) break;
                return true;
            }
            case CHEST: {
                if (!(item instanceof ItemSkin) || ((ItemSkin)item).getSkinType(stack) != SkinTypeRegistry.skinChest) break;
                return true;
            }
            case LEGS: {
                if (!(item instanceof ItemSkin) || ((ItemSkin)item).getSkinType(stack) != SkinTypeRegistry.skinLegs) break;
                return true;
            }
            case FEET: {
                if (!(item instanceof ItemSkin) || ((ItemSkin)item).getSkinType(stack) != SkinTypeRegistry.skinFeet) break;
                return true;
            }
            case LEFT_HAND: {
                return true;
            }
            case RIGHT_HAND: {
                return true;
            }
            case WINGS: {
                if (!(item instanceof ItemSkin) || ((ItemSkin)item).getSkinType(stack) != SkinTypeRegistry.skinWings) break;
                return true;
            }
        }
        return false;
    }

    public ISkinType getSkinType() {
        switch (this.slotType) {
            case HEAD: {
                return SkinTypeRegistry.skinHead;
            }
            case CHEST: {
                return SkinTypeRegistry.skinChest;
            }
            case LEGS: {
                return SkinTypeRegistry.skinLegs;
            }
            case FEET: {
                return SkinTypeRegistry.skinFeet;
            }
            case LEFT_HAND: {
                break;
            }
            case RIGHT_HAND: {
                break;
            }
            case WINGS: {
                return SkinTypeRegistry.skinWings;
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getBackgroundLocation() {
        ISkinType skinType = this.getSkinType();
        if (skinType != null) {
            return skinType.getSlotIcon();
        }
        return super.getBackgroundLocation();
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBackgroundSprite() {
        ISkinType skinType = this.getSkinType();
        if (skinType != null) {
            return new DummySprite("");
        }
        return super.getBackgroundSprite();
    }

    @SideOnly(value=Side.CLIENT)
    private class DummySprite
    extends TextureAtlasSprite {
        protected DummySprite(String spriteName) {
            super(spriteName);
        }

        public float func_94212_f() {
            return 1.0f;
        }

        public float func_94210_h() {
            return 1.0f;
        }

        public float func_94209_e() {
            return 0.0f;
        }

        public float func_94206_g() {
            return 0.0f;
        }
    }
}

