/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.init.items.paintingtool;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.api.common.painting.IPantableBlock;
import moe.plushie.armourers_workshop.api.common.skin.cubes.ICubeColour;
import moe.plushie.armourers_workshop.common.init.blocks.ModBlocks;
import moe.plushie.armourers_workshop.common.init.items.AbstractModItem;
import moe.plushie.armourers_workshop.common.init.sounds.ModSounds;
import moe.plushie.armourers_workshop.common.lib.EnumGuiId;
import moe.plushie.armourers_workshop.common.painting.IBlockPainter;
import moe.plushie.armourers_workshop.common.painting.tool.IConfigurableTool;
import moe.plushie.armourers_workshop.common.painting.tool.ToolOption;
import moe.plushie.armourers_workshop.common.painting.tool.ToolOptions;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityArmourer;
import moe.plushie.armourers_workshop.common.world.undo.UndoManager;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlendingTool
extends AbstractModItem
implements IConfigurableTool,
IBlockPainter {
    public ItemBlendingTool() {
        super("blending-tool");
        this.func_77637_a(ArmourersWorkshop.TAB_PAINTING_TOOLS);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.setSortPriority(14);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onDrawBlockHighlightEvent(DrawBlockHighlightEvent event) {
        AxisAlignedBB aabb;
        EntityPlayer player = event.getPlayer();
        World world = event.getPlayer().func_130014_f_();
        RayTraceResult target = event.getTarget();
        if (target != null && target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockPos pos = target.func_178782_a();
        EnumFacing facing = target.field_178784_b;
        IBlockState stateTarget = world.func_180495_p(pos);
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() != this) {
            return;
        }
        if (!(stateTarget.func_177230_c() instanceof IPantableBlock)) {
            return;
        }
        int radiusSample = (Integer)ToolOptions.RADIUS_SAMPLE.getValue(stack);
        int radiusEffect = (Integer)ToolOptions.RADIUS_EFFECT.getValue(stack);
        boolean restrictPlane = (Boolean)ToolOptions.PLANE_RESTRICT.getValue(stack);
        ArrayList<BlockPos> blockSamples = BlockUtils.findTouchingBlockFaces(world, pos, facing, radiusSample, restrictPlane);
        ArrayList<BlockPos> blockEffects = BlockUtils.findTouchingBlockFaces(world, pos, facing, radiusEffect, restrictPlane);
        double xOff = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
        double yOff = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
        double zOff = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
        float f1 = 0.002f;
        for (BlockPos posSample : blockSamples) {
            aabb = new AxisAlignedBB(posSample, posSample.func_177982_a(1, 1, 1));
            aabb = aabb.func_72317_d(-xOff, -yOff, -zOff);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179097_i();
            GlStateManager.func_179090_x();
            GlStateManager.func_179118_c();
            RenderGlobal.func_189697_a((AxisAlignedBB)aabb.func_72321_a((double)f1, (double)f1, (double)f1), (float)1.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            GlStateManager.func_179141_d();
            GlStateManager.func_179098_w();
            GlStateManager.func_179126_j();
            GlStateManager.func_179084_k();
        }
        for (BlockPos posEffect : blockEffects) {
            aabb = new AxisAlignedBB(posEffect, posEffect.func_177982_a(1, 1, 1));
            aabb = aabb.func_72317_d((double)0.1f, (double)0.1f, (double)0.1f).func_191195_a((double)0.2f, (double)0.2f, (double)0.2f);
            aabb = aabb.func_72317_d(-xOff, -yOff, -zOff);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179097_i();
            GlStateManager.func_179090_x();
            GlStateManager.func_179118_c();
            RenderGlobal.func_189697_a((AxisAlignedBB)aabb.func_72321_a((double)f1, (double)f1, (double)f1), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.5f);
            GlStateManager.func_179141_d();
            GlStateManager.func_179098_w();
            GlStateManager.func_179126_j();
            GlStateManager.func_179084_k();
        }
        event.setCanceled(true);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = worldIn.func_180495_p(pos);
        ItemStack stack = player.func_184586_b(hand);
        if (state.func_177230_c() instanceof IPantableBlock) {
            if (!worldIn.field_72995_K) {
                UndoManager.begin(player);
                this.usedOnBlockSide(stack, player, worldIn, pos, state.func_177230_c(), facing, false);
                UndoManager.end(player);
                worldIn.func_184133_a(null, pos, (SoundEvent)ModSounds.PAINT, SoundCategory.BLOCKS, 1.0f, worldIn.field_73012_v.nextFloat() * 0.2f + 0.9f);
            }
            return EnumActionResult.SUCCESS;
        }
        if (state.func_177230_c() == ModBlocks.ARMOURER & player.func_70093_af()) {
            TileEntity te;
            if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) != null && te instanceof TileEntityArmourer) {
                ((TileEntityArmourer)te).toolUsedOnArmourer(this, worldIn, stack, player);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Override
    public void usedOnBlockSide(ItemStack stack, EntityPlayer player, World world, BlockPos pos, Block block, EnumFacing face, boolean spawnParticles) {
        IPantableBlock pBlock;
        IBlockState stateTarget;
        int intensity = (Integer)ToolOptions.INTENSITY.getValue(stack);
        int radiusSample = (Integer)ToolOptions.RADIUS_SAMPLE.getValue(stack);
        int radiusEffect = (Integer)ToolOptions.RADIUS_EFFECT.getValue(stack);
        boolean restrictPlane = (Boolean)ToolOptions.PLANE_RESTRICT.getValue(stack);
        ArrayList<BlockPos> blockSamples = BlockUtils.findTouchingBlockFaces(world, pos, face, radiusSample, restrictPlane);
        ArrayList<BlockPos> blockEffects = BlockUtils.findTouchingBlockFaces(world, pos, face, radiusEffect, restrictPlane);
        if (blockSamples.size() == 0 | blockEffects.size() == 0) {
            return;
        }
        int r = 0;
        int g = 0;
        int b = 0;
        int validSamples = 0;
        for (BlockPos posSample : blockSamples) {
            ICubeColour c;
            stateTarget = world.func_180495_p(posSample);
            if (!(stateTarget.func_177230_c() instanceof IPantableBlock) || (c = (pBlock = (IPantableBlock)stateTarget.func_177230_c()).getColour((IBlockAccess)world, posSample)) == null) continue;
            r += c.getRed(face.ordinal()) & 0xFF;
            g += c.getGreen(face.ordinal()) & 0xFF;
            b += c.getBlue(face.ordinal()) & 0xFF;
            ++validSamples;
        }
        if (validSamples == 0) {
            return;
        }
        r /= validSamples;
        g /= validSamples;
        b /= validSamples;
        for (BlockPos posEffect : blockEffects) {
            stateTarget = world.func_180495_p(posEffect);
            if (!(stateTarget.func_177230_c() instanceof IPantableBlock)) continue;
            pBlock = (IPantableBlock)stateTarget.func_177230_c();
            int oldColour = pBlock.getColour((IBlockAccess)world, posEffect, face);
            byte oldPaintType = (byte)pBlock.getPaintType((IBlockAccess)world, posEffect, face).getId();
            Color oldC = new Color(oldColour);
            int oldR = oldC.getRed();
            int oldG = oldC.getGreen();
            int oldB = oldC.getBlue();
            float newR = (float)r / 100.0f * (float)intensity;
            newR += (float)oldR / 100.0f * (float)(100 - intensity);
            newR = MathHelper.func_76125_a((int)((int)newR), (int)0, (int)255);
            float newG = (float)g / 100.0f * (float)intensity;
            newG += (float)oldG / 100.0f * (float)(100 - intensity);
            newG = MathHelper.func_76125_a((int)((int)newG), (int)0, (int)255);
            float newB = (float)b / 100.0f * (float)intensity;
            newB += (float)oldB / 100.0f * (float)(100 - intensity);
            newB = MathHelper.func_76125_a((int)((int)newB), (int)0, (int)255);
            Color newC = new Color((int)newR, (int)newG, (int)newB);
            UndoManager.blockPainted(player, world, posEffect, oldColour, oldPaintType, face);
            ((IPantableBlock)block).setColour((IBlockAccess)world, posEffect, newC.getRGB(), face);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int intensity = (Integer)ToolOptions.INTENSITY.getValue(stack);
        int radiusSample = (Integer)ToolOptions.RADIUS_SAMPLE.getValue(stack);
        int radiusEffect = (Integer)ToolOptions.RADIUS_EFFECT.getValue(stack);
        tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.intensity", intensity));
        tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.radius.sample", radiusSample, radiusSample, 1));
        tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.radius.effect", radiusEffect, radiusEffect, 1));
        tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.openSettings"));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (worldIn.field_72995_K & playerIn.func_70093_af()) {
            playerIn.openGui((Object)ArmourersWorkshop.getInstance(), EnumGuiId.TOOL_OPTIONS.ordinal(), worldIn, 0, 0, 0);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Override
    public void getToolOptions(ArrayList<ToolOption<?>> toolOptionList) {
        toolOptionList.add(ToolOptions.INTENSITY);
        toolOptionList.add(ToolOptions.RADIUS_SAMPLE);
        toolOptionList.add(ToolOptions.RADIUS_EFFECT);
        toolOptionList.add(ToolOptions.PLANE_RESTRICT);
    }
}

