/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.init.blocks;

import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.api.common.skin.Point3D;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDescriptor;
import moe.plushie.armourers_workshop.common.init.blocks.AbstractModBlockContainer;
import moe.plushie.armourers_workshop.common.init.entities.EntitySeat;
import moe.plushie.armourers_workshop.common.init.items.ModItems;
import moe.plushie.armourers_workshop.common.lib.EnumGuiId;
import moe.plushie.armourers_workshop.common.permission.Permission;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinDescriptor;
import moe.plushie.armourers_workshop.common.skin.data.SkinProperties;
import moe.plushie.armourers_workshop.common.tileentities.TileEntitySkinnable;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.ModLogger;
import moe.plushie.armourers_workshop.utils.SkinNBTHelper;
import moe.plushie.armourers_workshop.utils.SkinUtils;
import moe.plushie.armourers_workshop.utils.UtilItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import org.apache.logging.log4j.Level;

public class BlockSkinnable
extends AbstractModBlockContainer {
    public static final PropertyDirection STATE_FACING = BlockHorizontal.field_185512_D;

    public BlockSkinnable() {
        this("skinnable");
    }

    public BlockSkinnable(String name) {
        super(name, Material.field_151573_f, SoundType.field_185852_e, false);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STATE_FACING, (Comparable)EnumFacing.NORTH));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STATE_FACING});
    }

    public IBlockState func_176203_a(int meta) {
        boolean northSouthBit = BlockSkinnable.getBitBool(meta, 0);
        boolean posNegBit = BlockSkinnable.getBitBool(meta, 1);
        EnumFacing facing = EnumFacing.EAST;
        facing = northSouthBit ? (posNegBit ? EnumFacing.SOUTH : EnumFacing.NORTH) : (posNegBit ? EnumFacing.EAST : EnumFacing.WEST);
        return this.func_176223_P().func_177226_a((IProperty)STATE_FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)STATE_FACING);
        int meta = 0;
        if (facing == EnumFacing.NORTH | facing == EnumFacing.SOUTH) {
            meta = BlockSkinnable.setBit(meta, 0, true);
        }
        if (facing == EnumFacing.EAST | facing == EnumFacing.SOUTH) {
            meta = BlockSkinnable.setBit(meta, 1, true);
        }
        return meta;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing enumfacing = placer.func_174811_aO().func_176734_d();
        return this.func_176223_P().func_177226_a((IProperty)STATE_FACING, (Comparable)enumfacing);
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (!world.field_72995_K) {
            TileEntitySkinnable te = this.getTileEntity((IBlockAccess)world, pos);
            if (te != null && te.getInventory() != null) {
                BlockUtils.dropInventoryBlocks(world, te.getInventory(), pos);
            }
            this.dropSkin(world, pos, false);
        }
        world.func_175713_t(pos);
        super.onBlockExploded(world, pos, explosion);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntitySkinnable te = this.getTileEntity((IBlockAccess)worldIn, pos);
        if (te != null && te.getInventory() != null) {
            te.killChildren(worldIn);
            BlockUtils.dropInventoryBlocks(worldIn, te.getInventory(), pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public void registerItemBlock(IForgeRegistry<Item> registry) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{STATE_FACING}).func_178441_a());
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockPos posLinked;
        IBlockState stateLinked;
        TileEntitySkinnable te = this.getTileEntity((IBlockAccess)worldIn, pos);
        if (te == null) {
            return false;
        }
        TileEntitySkinnable parentTe = te.getParent();
        if (parentTe == null) {
            return false;
        }
        if (parentTe.hasLinkedBlock() && !((stateLinked = worldIn.func_180495_p(posLinked = parentTe.getLinkedBlock())).func_177230_c() instanceof BlockSkinnable)) {
            return stateLinked.func_177230_c().func_180639_a(worldIn, posLinked, stateLinked, playerIn, hand, facing, hitX, hitY, hitZ);
        }
        Skin skin = this.getSkin((IBlockAccess)worldIn, pos);
        if (skin == null) {
            return false;
        }
        if (SkinProperties.PROP_BLOCK_SEAT.getValue(skin.getProperties()).booleanValue()) {
            return this.sitOnSeat(worldIn, parentTe.func_174877_v(), playerIn, skin);
        }
        if (SkinProperties.PROP_BLOCK_BED.getValue(skin.getProperties()).booleanValue()) {
            // empty if block
        }
        if (SkinProperties.PROP_BLOCK_INVENTORY.getValue(skin.getProperties()) | SkinProperties.PROP_BLOCK_ENDER_INVENTORY.getValue(skin.getProperties())) {
            this.openGui(playerIn, EnumGuiId.SKINNABLE, worldIn, parentTe.func_174877_v(), state, facing);
            return true;
        }
        return false;
    }

    private boolean sitOnSeat(World world, BlockPos pos, EntityPlayer player, Skin skin) {
        List seats = world.func_72872_a(EntitySeat.class, new AxisAlignedBB(pos));
        if (seats.size() == 0) {
            Point3D point = null;
            point = skin.getParts().get(0).getMarkerCount() > 0 ? skin.getParts().get(0).getMarker(0) : new Point3D(0, 0, 0);
            IBlockState blockState = world.func_180495_p(pos);
            if (blockState.func_177230_c() instanceof BlockSkinnable) {
                EnumFacing rotation = (EnumFacing)blockState.func_177229_b((IProperty)STATE_FACING);
                EntitySeat entitySeat = new EntitySeat(world, pos, point, rotation);
                world.func_72838_d((Entity)entitySeat);
                player.func_184205_a((Entity)entitySeat, true);
                return true;
            }
        }
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        Skin skin = this.getSkin(worldIn, pos);
        if (skin != null && SkinProperties.PROP_BLOCK_NO_COLLISION.getValue(skin.getProperties()).booleanValue()) {
            return field_185506_k;
        }
        return super.func_180646_a(blockState, worldIn, pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntitySkinnable te = this.getTileEntity(source, pos);
        if (te != null) {
            EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)STATE_FACING);
            if (dir == EnumFacing.NORTH) {
                return te.getBoundsForBlock((Block)this, 1, 0, 0);
            }
            if (dir == EnumFacing.EAST) {
                return te.getBoundsForBlock((Block)this, 0, 0, 1);
            }
            if (dir == EnumFacing.SOUTH) {
                return te.getBoundsForBlock((Block)this, 1, 0, 2);
            }
            if (dir == EnumFacing.WEST) {
                return te.getBoundsForBlock((Block)this, 2, 0, 1);
            }
        }
        return field_185505_j;
    }

    public boolean func_176209_a(IBlockState state, boolean hitIfLiquid) {
        if (!ArmourersWorkshop.isDedicated()) {
            return !this.checkCameraCollide();
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean checkCameraCollide() {
        if (Minecraft.func_71410_x().field_71439_g != null && !Minecraft.func_71410_x().field_71439_g.func_184218_aH()) {
            return false;
        }
        int renderCount = 0;
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            StackTraceElement element = stack[i];
            if (element.getClassName().equals(EntityRenderer.class.getName())) {
                ++renderCount;
            }
            if (renderCount != 4) continue;
            return true;
        }
        return false;
    }

    private TileEntitySkinnable getTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntitySkinnable) {
            return (TileEntitySkinnable)te;
        }
        ModLogger.log(Level.WARN, String.format("Block skin at x:%d y:%d z:%d has no tile entity.", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        return null;
    }

    private SkinDescriptor getSkinPointer(IBlockAccess world, BlockPos pos) {
        TileEntitySkinnable te = this.getTileEntity(world, pos);
        if (te != null) {
            return (SkinDescriptor)te.getSkinPointer();
        }
        ModLogger.log(Level.WARN, String.format("Block skin at x:%d y:%d z:%d has no skin data.", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        return null;
    }

    private Skin getSkin(IBlockAccess world, BlockPos pos) {
        SkinDescriptor skinPointer = this.getSkinPointer(world, pos);
        if (skinPointer != null) {
            return SkinUtils.getSkinDetectSide(skinPointer, true, true);
        }
        return null;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        Skin skin = this.getSkin(world, pos);
        if (skin != null) {
            return SkinProperties.PROP_BLOCK_LADDER.getValue(skin.getProperties());
        }
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        SkinDescriptor skinPointer = this.getSkinPointer((IBlockAccess)world, pos);
        if (skinPointer != null) {
            ItemStack returnStack = new ItemStack(ModItems.SKIN, 1);
            SkinNBTHelper.addSkinDataToStack(returnStack, skinPointer);
            return returnStack;
        }
        return ItemStack.field_190927_a;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!world.field_72995_K) {
            this.dropSkin(world, pos, player.field_71075_bZ.field_75098_d);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    private void dropSkin(World world, BlockPos pos, boolean isCreativeMode) {
        TileEntitySkinnable te = this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            ISkinDescriptor descriptor = te.getSkinPointer();
            if (descriptor != null) {
                if (!isCreativeMode) {
                    ItemStack skinStack = new ItemStack(ModItems.SKIN, 1);
                    SkinNBTHelper.addSkinDataToStack(skinStack, (SkinDescriptor)descriptor);
                    UtilItems.spawnItemInWorld(world, pos, skinStack);
                }
                te.killChildren(world);
            } else {
                ModLogger.log(Level.WARN, String.format("Block skin at x:%d y:%d z:%d had no skin data.", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
            }
        }
    }

    public TileEntity func_149915_a(World world, int p_149915_2_) {
        return new TileEntitySkinnable();
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        Skin skin = this.getSkin((IBlockAccess)world, pos);
        if (skin != null && !SkinProperties.PROP_BLOCK_MULTIBLOCK.getValue(skin.getProperties()).booleanValue()) {
            return super.rotateBlock(world, pos, axis);
        }
        return false;
    }

    @Override
    public void getPermissions(ArrayList<Permission> permissions) {
        super.getPermissions(permissions);
        permissions.add(new Permission(this.getPermissionName() + ".sit", DefaultPermissionLevel.ALL));
        permissions.add(new Permission(this.getPermissionName() + ".sleep", DefaultPermissionLevel.ALL));
    }
}

