/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.init.blocks;

import moe.plushie.armourers_workshop.client.config.ConfigHandlerClient;
import moe.plushie.armourers_workshop.common.init.blocks.AbstractModBlockContainer;
import moe.plushie.armourers_workshop.common.init.items.block.ModItemBlockWithMetadata;
import moe.plushie.armourers_workshop.common.lib.EnumGuiId;
import moe.plushie.armourers_workshop.common.tileentities.TileEntitySkinLibrary;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockSkinLibrary
extends AbstractModBlockContainer {
    public static final PropertyDirection STATE_FACING = BlockHorizontal.field_185512_D;
    public static final PropertyEnum<EnumLibraryType> STATE_TYPE = PropertyEnum.func_177709_a((String)"type", EnumLibraryType.class);

    public BlockSkinLibrary() {
        super("skin-library");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(STATE_TYPE, (Comparable)((Object)EnumLibraryType.NORMAL)).func_177226_a((IProperty)STATE_FACING, (Comparable)EnumFacing.NORTH));
        this.setSortPriority(198);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STATE_TYPE, STATE_FACING});
    }

    public IBlockState func_176203_a(int meta) {
        boolean typeBit = BlockSkinLibrary.getBitBool(meta, 0);
        boolean northSouthBit = BlockSkinLibrary.getBitBool(meta, 1);
        boolean posNegBit = BlockSkinLibrary.getBitBool(meta, 2);
        EnumLibraryType type = EnumLibraryType.NORMAL;
        if (typeBit) {
            type = EnumLibraryType.CREATIVE;
        }
        EnumFacing facing = EnumFacing.EAST;
        facing = northSouthBit ? (posNegBit ? EnumFacing.SOUTH : EnumFacing.NORTH) : (posNegBit ? EnumFacing.EAST : EnumFacing.WEST);
        return this.func_176223_P().func_177226_a(STATE_TYPE, (Comparable)((Object)type)).func_177226_a((IProperty)STATE_FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        EnumLibraryType type = (EnumLibraryType)((Object)state.func_177229_b(STATE_TYPE));
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)STATE_FACING);
        int meta = BlockSkinLibrary.setBit(0, 0, type == EnumLibraryType.CREATIVE);
        if (facing == EnumFacing.NORTH | facing == EnumFacing.SOUTH) {
            meta = BlockSkinLibrary.setBit(meta, 1, true);
        }
        if (facing == EnumFacing.EAST | facing == EnumFacing.SOUTH) {
            meta = BlockSkinLibrary.setBit(meta, 2, true);
        }
        return meta;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing enumfacing = placer.func_174811_aO().func_176734_d();
        EnumLibraryType type = EnumLibraryType.NORMAL;
        if (placer.func_184586_b(hand).func_77960_j() == 1) {
            type = EnumLibraryType.CREATIVE;
        }
        return this.func_176223_P().func_177226_a((IProperty)STATE_FACING, (Comparable)enumfacing).func_177226_a(STATE_TYPE, (Comparable)((Object)type));
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, 0));
        items.add((Object)new ItemStack((Block)this, 1, 1));
    }

    public int func_180651_a(IBlockState state) {
        if (state.func_177229_b(STATE_TYPE) == EnumLibraryType.CREATIVE) {
            return 1;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        if (!ConfigHandlerClient.useClassicBlockModels) {
            return BlockRenderLayer.CUTOUT_MIPPED;
        }
        return BlockRenderLayer.SOLID;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    @Override
    public void registerItemBlock(IForgeRegistry<Item> registry) {
        registry.register((IForgeRegistryEntry)((Item)new ModItemBlockWithMetadata((Block)this).setRegistryName(this.getRegistryName())).func_77627_a(true));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        if (!ConfigHandlerClient.useClassicBlockModels) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("armourers_workshop", this.func_149739_a()), "normal"));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)1, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("armourers_workshop", this.func_149739_a()), "creative"));
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("armourers_workshop", this.func_149739_a() + "-classic"), "normal"));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)1, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("armourers_workshop", this.func_149739_a() + "-classic"), "creative"));
            ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178439_a("-classic").func_178442_a(new IProperty[]{STATE_FACING}).func_178441_a());
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        this.openGui(playerIn, EnumGuiId.ARMOUR_LIBRARY, worldIn, pos, state, facing);
        return true;
    }

    public TileEntity func_149915_a(World world, int p_149915_2_) {
        return new TileEntitySkinLibrary();
    }

    public static enum EnumLibraryType implements IStringSerializable
    {
        NORMAL,
        CREATIVE;


        public String func_176610_l() {
            return this.toString().toLowerCase();
        }
    }
}

