/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common;

import java.util.LinkedHashMap;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class ModRegistry<TYPE extends IRegistryItem> {
    private LinkedHashMap<ResourceLocation, TYPE> registryMap = new LinkedHashMap();
    private final String name;

    public ModRegistry(String name) {
        this.name = name;
    }

    public boolean register(TYPE value) {
        if (value == null) {
            ModLogger.log(Level.WARN, "[" + this.name + "] A mod tried to register a null value.");
            return false;
        }
        if (value.getRegistryName() == null || value.getRegistryName().toString().trim().isEmpty()) {
            ModLogger.log(Level.WARN, "[" + this.name + "] A mod tried to register with an invalid registry key.");
            return false;
        }
        if (this.registryMap.containsKey(value.getRegistryName())) {
            ModLogger.log(Level.WARN, "[" + this.name + "] A mod tried to register with a key that is in use.");
            return false;
        }
        ModLogger.log(String.format("[" + this.name + "] Registering: %s as %s.", value.getName(), value.getRegistryName()));
        this.registryMap.put(value.getRegistryName(), value);
        return true;
    }

    public TYPE get(ResourceLocation key) {
        return (TYPE)((IRegistryItem)this.registryMap.get(key));
    }

    public static interface IRegistryItem {
        public ResourceLocation getRegistryName();

        public String getName();
    }

    public static class RegistryItem
    implements IRegistryItem {
        private final String name;

        public RegistryItem(String name) {
            this.name = name;
        }

        @Override
        public ResourceLocation getRegistryName() {
            return new ResourceLocation("armourers_workshop", this.name);
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

