/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.render;

import java.awt.Rectangle;
import java.util.ArrayDeque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class ModRenderHelper {
    private static float lightX;
    private static float lightY;
    private static ArrayDeque<Rectangle> scissorList;

    public static void disableLighting() {
        lightX = OpenGlHelper.lastBrightnessX;
        lightY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
    }

    public static void enableLighting() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightX, (float)lightY);
    }

    public static void setLightingForBlock(World world, BlockPos pos) {
        int i = world.func_175626_b(pos, 0);
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
    }

    public static void setGLForSkinRender() {
    }

    public static void unsetGLForSkinRender() {
    }

    public static void setGLForSkinRenderGUI() {
        ModRenderHelper.enableAlphaBlend();
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
    }

    public static void unsetGLForSkinRenderGUI() {
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void enableAlphaBlend() {
        ModRenderHelper.enableAlphaBlend(770, 771);
    }

    public static void enableAlphaBlend(int sfactor, int dfactor) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)sfactor, (int)dfactor);
    }

    public static void disableAlphaBlend() {
        GlStateManager.func_179084_k();
    }

    public static void enableScissor(int x, int y, int width, int height, boolean scaled) {
        Rectangle cut = new Rectangle(x, y, width, height);
        Rectangle rec = scissorList.peek();
        if (rec != null) {
            int left = x;
            int right = x + width;
            int top = y;
            int bottom = y + height;
            if (left < rec.x) {
                left = rec.x;
            }
            if (right > rec.x + rec.width) {
                right = rec.x + rec.width;
            }
            if (top < rec.y) {
                top = rec.y;
            }
            if (bottom > rec.y + rec.height) {
                bottom = rec.y + rec.height;
            }
            if (right < left) {
                right = left;
            }
            if (bottom < top) {
                bottom = top;
            }
            cut = new Rectangle(left, top, right - left, bottom - top);
        }
        scissorList.push(cut);
        ModRenderHelper.enableScissorScaled(cut.x, cut.y, cut.width, cut.height);
    }

    private static void enableScissorScaled(int x, int y, int width, int height) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution sr = new ScaledResolution(mc);
        double scaledWidth = (double)mc.field_71443_c / sr.func_78327_c();
        double scaledHeight = (double)mc.field_71440_d / sr.func_78324_d();
        int xScaled = MathHelper.func_76128_c((double)((double)x * scaledWidth));
        int yScaled = mc.field_71440_d - MathHelper.func_76128_c((double)(((double)y + (double)height) * scaledHeight));
        int widthScaled = MathHelper.func_76128_c((double)((double)width * scaledWidth));
        int heightScaled = MathHelper.func_76128_c((double)((double)height * scaledHeight));
        GL11.glEnable((int)3089);
        GL11.glScissor((int)xScaled, (int)yScaled, (int)widthScaled, (int)heightScaled);
    }

    public static void disableScissor() {
        scissorList.poll();
        Rectangle rec = scissorList.peek();
        if (rec != null) {
            ModRenderHelper.enableScissorScaled(rec.x, rec.y, rec.width, rec.height);
        } else {
            GL11.glDisable((int)3089);
        }
    }

    public static Rectangle getScissor() {
        return scissorList.peek();
    }

    static {
        scissorList = new ArrayDeque();
    }
}

