/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.render;

import moe.plushie.armourers_workshop.client.render.SkinPartRenderData;
import moe.plushie.armourers_workshop.client.render.SkinPartRenderer;
import moe.plushie.armourers_workshop.client.render.SkinRenderData;
import moe.plushie.armourers_workshop.common.skin.advanced.AdvancedData;
import moe.plushie.armourers_workshop.common.skin.advanced.AdvancedPart;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinPart;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;

public final class AdvancedPartRenderer {
    public static void renderAdvancedSkin(Skin skin, SkinRenderData renderData, Entity entity, AdvancedData data, AdvancedPart part) {
        AdvancedPartRenderer.updateParts(skin, renderData, entity, data, part, 0);
        AdvancedPartRenderer.renderParts(skin, renderData, entity, part);
    }

    private static void updateParts(Skin skin, SkinRenderData renderData, Entity entity, AdvancedData data, AdvancedPart part, int depth) {
        double angle = 0.0;
        double flapTime = 5000.0;
        if (entity != null) {
            angle = ((double)System.currentTimeMillis() + (double)entity.func_145782_y()) % flapTime;
            angle = Math.sin(angle / flapTime * Math.PI * 2.0);
        }
        double maxAngle = 5.0;
        double minAngle = -5.0;
        double fullAngle = maxAngle - minAngle;
        fullAngle *= angle;
        int owo = depth % 2;
        if (owo == 1) {
            // empty if block
        }
        double x = 0.0;
        if (entity != null && entity.func_130014_f_().func_72896_J()) {
            x = 30.0;
        }
        part.rotationAngleOffset = new Vec3d(0.0, 0.0, 0.0);
        part.rotationAngleOffset = new Vec3d(x, fullAngle, fullAngle);
        for (int i = 0; i < part.getChildren().size(); ++i) {
            AdvancedPart advancedPart = part.getChildren().get(i);
            AdvancedPartRenderer.updateParts(skin, renderData, entity, data, advancedPart, depth + 1);
        }
    }

    private static void renderParts(Skin skin, SkinRenderData renderData, Entity entity, AdvancedPart part) {
        GlStateManager.func_179094_E();
        SkinPart skinPart = skin.getParts().get(0);
        Vec3d pos = part.pos.func_178787_e(part.posOffset);
        Vec3d rot = part.rotationAngle.func_178787_e(part.rotationAngleOffset);
        float scale = renderData.getScale() * part.scale;
        GlStateManager.func_179137_b((double)(pos.field_72450_a * (double)scale), (double)(pos.field_72448_b * (double)scale), (double)(pos.field_72449_c * (double)scale));
        GlStateManager.func_179114_b((float)((float)rot.field_72450_a), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)rot.field_72448_b), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)rot.field_72449_c), (float)0.0f, (float)0.0f, (float)1.0f);
        AdvancedPartRenderer.renderPart(new SkinPartRenderData(skinPart, renderData));
        for (int i = 0; i < part.getChildren().size(); ++i) {
            AdvancedPartRenderer.renderParts(skin, renderData, entity, part.getChildren().get(i));
        }
        GlStateManager.func_179121_F();
    }

    private static void renderPart(SkinPartRenderData partRenderData) {
        SkinPartRenderer.INSTANCE.renderPart(partRenderData);
    }
}

