/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.helper;

import com.mojang.authlib.GameProfile;
import moe.plushie.armourers_workshop.client.texture.PlayerTexture;
import moe.plushie.armourers_workshop.common.data.type.TextureType;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityMannequin;
import moe.plushie.armourers_workshop.proxies.ClientProxy;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class MannequinTextureHelper {
    private static final String TAG_OWNER = "owner";
    private static final String TAG_IMAGE_URL = "imageUrl";
    private static final PlayerTexture NO_TEXTURE = new PlayerTexture("", TextureType.USER);

    private MannequinTextureHelper() {
    }

    public static PlayerTexture getMannequinTexture(ItemStack itemStack) {
        PlayerTexture playerTexture = NO_TEXTURE;
        GameProfile gameProfile = null;
        String imageUrl = null;
        if (itemStack.func_77942_o()) {
            NBTTagCompound compound = itemStack.func_77978_p();
            if (compound.func_150297_b(TAG_OWNER, 10)) {
                gameProfile = NBTUtil.func_152459_a((NBTTagCompound)compound.func_74775_l(TAG_OWNER));
            }
            if (compound.func_150297_b(TAG_IMAGE_URL, 8)) {
                imageUrl = compound.func_74779_i(TAG_IMAGE_URL);
            }
        }
        if (gameProfile != null) {
            playerTexture = MannequinTextureHelper.getMannequinTexture(gameProfile.getName(), TextureType.USER);
        }
        if (!StringUtils.func_151246_b(imageUrl)) {
            playerTexture = MannequinTextureHelper.getMannequinTexture(imageUrl, TextureType.URL);
        }
        return playerTexture;
    }

    public static PlayerTexture getMannequinTexture(TileEntityMannequin tileEntity) {
        PlayerTexture playerTexture = NO_TEXTURE;
        if (tileEntity.PROP_OWNER.get() != null && tileEntity.PROP_TEXTURE_TYPE.get() == TextureType.USER) {
            String name = tileEntity.PROP_OWNER.get().getName();
            playerTexture = MannequinTextureHelper.getMannequinTexture(name, TextureType.USER);
        }
        if (!StringUtils.func_151246_b((String)tileEntity.PROP_IMAGE_URL.get()) && tileEntity.PROP_TEXTURE_TYPE.get() == TextureType.URL) {
            playerTexture = MannequinTextureHelper.getMannequinTexture(tileEntity.PROP_IMAGE_URL.get(), TextureType.URL);
        }
        return playerTexture;
    }

    private static PlayerTexture getMannequinTexture(String textureString, TextureType textureType) {
        return ClientProxy.playerTextureDownloader.getPlayerTexture(textureString, textureType);
    }
}

