/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.hologramprojector;

import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.controls.GuiCheckBox;
import moe.plushie.armourers_workshop.client.gui.controls.GuiDropDownList;
import moe.plushie.armourers_workshop.client.gui.controls.GuiTabPanel;
import moe.plushie.armourers_workshop.common.data.type.Rectangle_I_2D;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityHologramProjector;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.client.config.GuiUtils;

public class GuiHologramProjectorTabExtra
extends GuiTabPanel
implements GuiDropDownList.IDropDownListCallback {
    private final String inventoryName;
    private final TileEntityHologramProjector tileEntity;
    private GuiCheckBox checkGlowing;
    private GuiDropDownList dropDownPowerMode;

    public GuiHologramProjectorTabExtra(int tabId, GuiScreen parent, String inventoryName, TileEntityHologramProjector tileEntity) {
        super(tabId, parent, true);
        this.inventoryName = inventoryName;
        this.tileEntity = tileEntity;
    }

    @Override
    public void initGui(int xPos, int yPos, int width, int height) {
        super.initGui(xPos, yPos, width, height);
        this.checkGlowing = new GuiCheckBox(-1, (int)((float)width / 2.0f - 100.0f) + 10, 30, GuiHelper.getLocalizedControlName(this.inventoryName, "glowing", new Object[0]), this.tileEntity.getGlowing().get());
        this.dropDownPowerMode = new GuiDropDownList(0, (int)((float)width / 2.0f - 100.0f) + 10, 55, 80, "", this);
        for (int i = 0; i < TileEntityHologramProjector.PowerMode.values().length; ++i) {
            TileEntityHologramProjector.PowerMode powerMode = TileEntityHologramProjector.PowerMode.values()[i];
            this.dropDownPowerMode.addListItem(GuiHelper.getLocalizedControlName(this.inventoryName, "powerMode." + powerMode.toString().toLowerCase(), new Object[0]), powerMode.toString(), true);
            if (powerMode != this.tileEntity.getPowerMode().get()) continue;
            this.dropDownPowerMode.setListSelectedIndex(i);
        }
        this.buttonList.add(this.checkGlowing);
        this.buttonList.add(this.dropDownPowerMode);
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (button == this.checkGlowing) {
            this.tileEntity.getGlowing().set(this.checkGlowing.isChecked());
            this.tileEntity.updateProperty(this.tileEntity.getGlowing());
        }
    }

    @Override
    public void drawBackgroundLayer(float partialTickTime, int mouseX, int mouseY) {
        Rectangle_I_2D rec = new Rectangle_I_2D(0, 0, 200, 78);
        rec.x = this.width / 2 - rec.width / 2;
        GuiUtils.drawContinuousTexturedBox((int)rec.x, (int)rec.y, (int)0, (int)138, (int)rec.width, (int)rec.height, (int)38, (int)38, (int)4, (float)this.field_73735_i);
    }

    @Override
    public void drawForegroundLayer(int mouseX, int mouseY, float partialTickTime) {
        super.drawForegroundLayer(mouseX, mouseY, partialTickTime);
        this.dropDownPowerMode.drawForeground(this.mc, mouseX, mouseY, partialTickTime);
        String labelPowerMode = GuiHelper.getLocalizedControlName(this.inventoryName, "label.powerMode", new Object[0]);
        this.fontRenderer.func_78276_b(labelPowerMode, (int)((float)this.width / 2.0f - 100.0f) + 10, 45, 0x404040);
    }

    @Override
    public void onDropDownListChanged(GuiDropDownList dropDownList) {
        this.tileEntity.getPowerMode().set(TileEntityHologramProjector.PowerMode.valueOf(this.dropDownPowerMode.getListSelectedItem().tag));
        this.tileEntity.updateProperty(this.tileEntity.getPowerMode());
    }
}

