/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.globallibrary.panels;

import com.google.common.util.concurrent.FutureCallback;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.client.gui.controls.GuiControlDetailList;
import moe.plushie.armourers_workshop.client.gui.controls.GuiPanel;
import moe.plushie.armourers_workshop.client.gui.globallibrary.GuiGlobalLibrary;
import moe.plushie.armourers_workshop.common.library.global.task.mod.GlobalTaskGetReportList;
import moe.plushie.armourers_workshop.common.library.global.task.user.GlobalTaskSkinReport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;

public class GuiGlobalLibraryPanelModeration
extends GuiPanel {
    private final String guiName;
    private final GuiControlDetailList listReports;
    private int pageIndex = 0;
    private GlobalTaskGetReportList.Filter filter = GlobalTaskGetReportList.Filter.OPEN;
    private GlobalTaskGetReportList.Result result = null;

    public GuiGlobalLibraryPanelModeration(GuiScreen parent) {
        super(parent, 0, 0, 1, 1);
        this.guiName = ((GuiGlobalLibrary)parent).getGuiName() + ".panel.info";
        this.listReports = new GuiControlDetailList(this.x + 5, this.y + 20, this.width - 10, this.height - 25);
        this.listReports.addColumn("date", 106);
        this.listReports.addColumn("userId", 40);
        this.listReports.addColumn("skinId", 40);
        this.listReports.addColumn("reportType", 72);
        this.listReports.addColumn("message", -1);
    }

    @Override
    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        this.listReports.setPosAndSize(this.x + 5, this.y + 20, this.width - 10, this.height - 25);
        this.buttonList.add(this.listReports);
    }

    @Override
    public GuiPanel setVisible(boolean visible) {
        if (visible & !this.visible) {
            this.pageIndex = 0;
            this.getReportList();
        }
        return super.setVisible(visible);
    }

    private int getMaxPerPage() {
        return 20;
    }

    private void getReportList() {
        this.result = null;
        new GlobalTaskGetReportList(this.pageIndex, this.getMaxPerPage(), this.filter).createTaskAndRun(new FutureCallback<GlobalTaskGetReportList.Result>(){

            public void onSuccess(final GlobalTaskGetReportList.Result result) {
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        GuiGlobalLibraryPanelModeration.this.result = result;
                        GuiGlobalLibraryPanelModeration.this.listReports.clearItems();
                        ArrayList<String> names = new ArrayList<String>();
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd MM:dd:HH");
                        for (GlobalTaskSkinReport.SkinReport skinReport : result.getSkinReports()) {
                            names.add(sdf.format(skinReport.getDate()));
                            names.add(String.valueOf(skinReport.getUserId()));
                            names.add(String.valueOf(skinReport.getSkinId()));
                            names.add(I18n.func_135052_a((String)skinReport.getReportType().getLangKey(), (Object[])new Object[0]));
                            names.add(skinReport.getMessage());
                            GuiGlobalLibraryPanelModeration.this.listReports.addItem(names.toArray(new String[names.size()]));
                            names.clear();
                        }
                    }
                });
            }

            public void onFailure(Throwable t) {
                t.printStackTrace();
            }
        });
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTickTime) {
        if (!this.visible) {
            return;
        }
        this.func_73733_a(this.x, this.y, this.x + this.width, this.y + this.height, -1072689136, -804253680);
        super.draw(mouseX, mouseY, partialTickTime);
    }
}

