/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.controls;

import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.client.gui.controls.GuiScrollbar;
import moe.plushie.armourers_workshop.client.render.ModRenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiDropDownList
extends GuiButtonExt {
    private List<DropDownListItem> listItems;
    private int selectedIndex;
    private int hoverIndex;
    private boolean isMouseDownOver;
    private boolean isDroppedDown;
    private int dropButtonX;
    private int dropButtonY;
    private int dropButtonWidth;
    private int dropButtonHeight;
    private IDropDownListCallback callback;
    private boolean scissor = false;
    private GuiScrollbar scrollbar = new GuiScrollbar(0, this.field_146128_h, this.field_146129_i, 10, 10, "", false);
    private int maxDisplayCount = 0;
    private int scrollAmount = 0;
    private boolean mouseDown = false;

    public GuiDropDownList(int id, int xPos, int yPos, int width, String displayString, IDropDownListCallback callback) {
        super(id, xPos, yPos, width, 14, displayString);
        this.callback = callback;
        this.listItems = new ArrayList<DropDownListItem>();
        this.selectedIndex = 0;
        this.hoverIndex = -1;
        this.isMouseDownOver = false;
        this.isDroppedDown = false;
        this.dropButtonHeight = this.field_146121_g;
        this.dropButtonWidth = 14;
        this.dropButtonY = this.field_146129_i;
        this.dropButtonX = this.field_146128_h + this.field_146120_f - this.dropButtonWidth;
    }

    public void setMaxDisplayCount(int maxDisplayCount) {
        this.maxDisplayCount = maxDisplayCount;
    }

    public boolean getIsDroppedDown() {
        return this.isDroppedDown;
    }

    public int getDropdownListCount() {
        int listSize;
        int limit = listSize = this.listItems.size();
        if (this.maxDisplayCount > 0) {
            limit = MathHelper.func_76125_a((int)this.maxDisplayCount, (int)1, (int)listSize);
        }
        return limit;
    }

    public boolean hasScrollbar() {
        return this.getDropdownListCount() < this.listItems.size();
    }

    public void setScissor(boolean scissor) {
        this.scissor = scissor;
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partial) {
        if (this.field_146125_m) {
            this.mouseCheck();
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            int k = this.func_146114_a(this.field_146123_n);
            GuiUtils.drawContinuousTexturedBox((ResourceLocation)field_146122_a, (int)this.field_146128_h, (int)this.field_146129_i, (int)0, (int)46, (int)this.field_146120_f, (int)this.field_146121_g, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.field_73735_i);
            this.drawDropDownButton(mc, mouseX, mouseY);
            if (this.getListSelectedItem() != null) {
                if (this.scissor) {
                    ModRenderHelper.enableScissor(this.field_146128_h, this.field_146129_i, this.field_146120_f - this.dropButtonWidth, this.field_146121_g, true);
                }
                this.getListSelectedItem().drawItem(mc, this, this.field_146128_h + 3, this.field_146129_i + 3, mouseX, mouseY, partial, true);
                if (this.scissor) {
                    ModRenderHelper.disableScissor();
                }
            }
        }
    }

    public void drawForeground(Minecraft mc, int mouseX, int mouseY, float partial) {
        this.hoverIndex = -1;
        if (this.isDroppedDown) {
            int listSize = this.listItems.size();
            int limit = this.getDropdownListCount();
            this.scrollbar.field_146128_h = this.field_146128_h + this.field_146120_f - 10;
            this.scrollbar.field_146129_i = this.field_146129_i + this.field_146121_g + 1;
            this.scrollbar.field_146121_g = 10 * limit + 4;
            this.scrollbar.setSliderMaxValue(listSize - limit);
            this.scrollAmount = this.scrollbar.getValue();
            int dropDownWidth = this.field_146120_f;
            if (this.hasScrollbar()) {
                dropDownWidth = this.field_146120_f - 10;
            }
            GuiUtils.drawContinuousTexturedBox((ResourceLocation)field_146122_a, (int)this.field_146128_h, (int)(this.field_146129_i + this.field_146121_g + 1), (int)0, (int)46, (int)dropDownWidth, (int)(10 * limit + 4), (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.field_73735_i);
            if (this.hasScrollbar()) {
                this.scrollbar.func_191745_a(mc, mouseX, mouseY, partial);
            }
            for (int i = 0; i < limit; ++i) {
                DropDownListItem listItem = this.listItems.get(i + this.scrollAmount);
                int textX = this.field_146128_h + 4;
                int textY = this.field_146129_i + this.field_146121_g + 4 + i * 10;
                if (this.scissor) {
                    if (this.hasScrollbar()) {
                        ModRenderHelper.enableScissor(textX, textY, this.field_146120_f - this.dropButtonWidth - 1, this.field_146121_g, true);
                    } else {
                        ModRenderHelper.enableScissor(textX, textY, this.field_146120_f - 8, this.field_146121_g, true);
                    }
                }
                if (listItem.isMouseOver(this, textX, textY, mouseX, mouseY) & listItem.enabled) {
                    this.hoverIndex = i + this.scrollAmount;
                }
                listItem.drawItem(mc, this, textX, textY, mouseX, mouseY, partial, false);
                if (!this.scissor) continue;
                ModRenderHelper.disableScissor();
            }
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void mouseCheck() {
        if (Loader.isModLoaded((String)"TooManyItems") && Mouse.isCreated()) {
            if (Mouse.isButtonDown((int)0)) {
                this.mouseDown = true;
            } else if (this.mouseDown) {
                this.mouseDown = false;
                Minecraft mc = Minecraft.func_71410_x();
                ScaledResolution reso = new ScaledResolution(mc);
                double scaleWidth = (double)mc.field_71443_c / reso.func_78327_c();
                double scaleHeight = (double)mc.field_71440_d / reso.func_78324_d();
                int mouseX = (int)((double)Mouse.getX() / scaleWidth);
                int mouseY = (int)((double)(-(Mouse.getY() - mc.field_71440_d)) / scaleHeight);
                this.func_146118_a(mouseX, mouseY);
            }
        }
    }

    private boolean mouseOverDropDownButton(int mouseX, int mouseY) {
        return mouseX >= this.dropButtonX && mouseY >= this.dropButtonY && mouseX < this.dropButtonX + this.dropButtonWidth && mouseY < this.dropButtonY + this.dropButtonHeight;
    }

    private void drawDropDownButton(Minecraft mc, int mouseX, int mouseY) {
        int k = this.func_146114_a(this.mouseOverDropDownButton(mouseX, mouseY));
        GuiUtils.drawContinuousTexturedBox((ResourceLocation)field_146122_a, (int)this.dropButtonX, (int)this.dropButtonY, (int)0, (int)(46 + k * 20), (int)this.dropButtonWidth, (int)this.dropButtonHeight, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.field_73735_i);
        String dropDownArrow = "v";
        if (this.isDroppedDown) {
            dropDownArrow = "^";
        }
        int arrowWidth = mc.field_71466_p.func_78256_a(dropDownArrow);
        mc.field_71466_p.func_78276_b(dropDownArrow, this.dropButtonX + this.dropButtonWidth / 2 - arrowWidth / 2, this.dropButtonY + 3, 0xFFFFFF);
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        int oldHeight = this.field_146121_g;
        if (this.isDroppedDown) {
            this.scrollbar.func_146116_c(mc, mouseX, mouseY);
            this.field_146121_g += 10 * this.listItems.size() + 4;
        }
        if (super.func_146116_c(mc, mouseX, mouseY)) {
            if (this.isDroppedDown) {
                this.field_146121_g = oldHeight;
            }
            this.isMouseDownOver = this.mouseOverDropDownButton(mouseX, mouseY);
            return true;
        }
        if (this.isDroppedDown) {
            this.field_146121_g = oldHeight;
            this.isDroppedDown = false;
        }
        return false;
    }

    public void func_146118_a(int mouseX, int mouseY) {
        if (this.isDroppedDown) {
            this.scrollbar.func_146118_a(mouseX, mouseY);
        }
        if (this.isMouseDownOver && this.mouseOverDropDownButton(mouseX, mouseY)) {
            this.isDroppedDown = !this.isDroppedDown;
            this.isMouseDownOver = false;
        }
        if (this.hoverIndex != -1) {
            this.setListSelectedIndex(this.hoverIndex);
            this.isDroppedDown = false;
            if (this.callback != null) {
                this.callback.onDropDownListChanged(this);
            }
        }
    }

    public void clearList() {
        this.listItems.clear();
    }

    public void addListItem(DropDownListItem listItem) {
        this.listItems.add(listItem);
    }

    public void addListItem(String displayText) {
        this.addListItem(displayText, "", true);
    }

    public void addListItem(String displayText, String tag, boolean enabled) {
        this.listItems.add(new DropDownListItem(displayText, tag, enabled));
    }

    public DropDownListItem getListIndex(int index) {
        if (index >= 0 & index < this.listItems.size()) {
            return this.listItems.get(index);
        }
        return null;
    }

    public int getListSelectedIndex() {
        return this.selectedIndex;
    }

    public DropDownListItem getListSelectedItem() {
        return this.getListIndex(this.selectedIndex);
    }

    public void setListSelectedIndex(int index) {
        this.selectedIndex = index;
        this.field_146126_j = this.listItems.get((int)this.selectedIndex).displayText;
    }

    public int getListSize() {
        return this.listItems.size();
    }

    public static class DropDownListItem {
        public String displayText;
        public String tag;
        public boolean enabled;

        public DropDownListItem(String displayText, String tag, boolean enabled) {
            this.displayText = displayText;
            this.tag = tag;
            this.enabled = enabled;
        }

        public boolean isMouseOver(GuiDropDownList parent, int x, int y, int mouseX, int mouseY) {
            int textWidth = parent.field_146120_f - 8;
            if (parent.hasScrollbar()) {
                textWidth -= 10;
            }
            int textHeight = 8;
            return mouseX >= x && mouseY >= y && mouseX < x + textWidth && mouseY < y + textHeight;
        }

        public void drawItem(Minecraft mc, GuiDropDownList parent, int x, int y, int mouseX, int mouseY, float partial, boolean topItem) {
            int textWidth = parent.field_146120_f - 8;
            if (parent.hasScrollbar()) {
                textWidth -= 10;
            }
            int textHeight = 8;
            int textColour = 0xFFFFFF;
            if (!this.enabled) {
                textColour = -3407872;
            } else if (this.isMouseOver(parent, x, y, mouseX, mouseY) & !topItem && this.enabled) {
                textColour = 0xFFFFA0;
                Gui.func_73734_a((int)x, (int)y, (int)(x + textWidth), (int)(y + textHeight), (int)0x44CCCCCC);
            }
            mc.field_71466_p.func_78276_b(this.displayText, x, y, textColour);
        }
    }

    public static interface IDropDownListCallback {
        public void onDropDownListChanged(GuiDropDownList var1);
    }
}

