/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.controls;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiControlDetailList
extends GuiButtonExt {
    private static final ResourceLocation TEXTURE = new ResourceLocation("armourers_workshop:textures/gui/_controls/skin-panel.png");
    private final ArrayList<IGuiDetailListColumn> columns = new ArrayList();
    private final ArrayList<IGuiDetailListItem> items = new ArrayList();
    protected int scrollAmount;
    protected int selectedIndex;

    public GuiControlDetailList(int xPos, int yPos, int width, int height) {
        super(-1, xPos, yPos, width, height, "");
    }

    public void setPosAndSize(int x, int y, int width, int height) {
        this.field_146128_h = x;
        this.field_146129_i = y;
        this.field_146120_f = width;
        this.field_146121_g = height;
    }

    public void addColumn(IGuiDetailListColumn column) {
        this.columns.add(column);
    }

    public void addColumn(String name, int width) {
        this.columns.add(new GuiDetailListColumn(name, width));
    }

    public IGuiDetailListColumn getColumn(int index) {
        if (index >= 0 & index < this.columns.size()) {
            return this.columns.get(index);
        }
        return null;
    }

    public void removeColumn(int index) {
        this.columns.remove(index);
    }

    public void clearColumns() {
        this.columns.clear();
    }

    public void addItem(IGuiDetailListItem item) {
        this.items.add(item);
    }

    public void addItem(String ... names) {
        this.items.add(new GuiDetailListItem(names));
    }

    public IGuiDetailListItem getItem(int index) {
        if (index >= 0 & index < this.items.size()) {
            return this.items.get(index);
        }
        return null;
    }

    public void removeItem(int index) {
        this.items.remove(index);
    }

    public void clearItems() {
        this.items.clear();
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (!this.field_146125_m) {
            return;
        }
        this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
        int k = this.func_146114_a(this.field_146123_n);
        GuiUtils.drawContinuousTexturedBox((ResourceLocation)field_146122_a, (int)this.field_146128_h, (int)this.field_146129_i, (int)0, (int)46, (int)this.field_146120_f, (int)this.field_146121_g, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.field_73735_i);
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get(i).draw(mc, this.field_146128_h + 1, this.field_146129_i + 1 + 10 * i, mouseX, mouseY, partialTicks, this);
        }
    }

    public void func_146113_a(SoundHandler soundHandlerIn) {
    }

    public class GuiDetailListItem
    implements IGuiDetailListItem {
        public String[] names;

        public GuiDetailListItem(String[] names) {
            this.names = names;
        }

        @Override
        public void draw(Minecraft mc, int x, int y, int mouseX, int mouseY, float partialTicks, GuiControlDetailList parent) {
            int xOffset = 0;
            for (int i = 0; i < this.names.length; ++i) {
                int columnWidth = 10;
                IGuiDetailListColumn column = parent.getColumn(i);
                if (column == null) continue;
                columnWidth = column.getWidth(parent.field_146120_f);
                if (columnWidth == -1) {
                    columnWidth = parent.field_146120_f - 2 - xOffset;
                }
                Gui.func_73734_a((int)(x + xOffset), (int)y, (int)(x + xOffset + columnWidth), (int)(y + 9), (int)-863993728);
                mc.field_71466_p.func_78276_b(this.names[i], x + 1 + xOffset, y + 1, 0xFFFFFF);
                xOffset += columnWidth + 1;
            }
        }
    }

    public class GuiDetailListColumn
    implements IGuiDetailListColumn {
        private final String name;
        private int width;

        public GuiDetailListColumn(String name, int width) {
            this.name = name;
            this.width = width;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getWidth(int listWidth) {
            return this.width;
        }
    }

    public static interface IGuiDetailListItem {
        public void draw(Minecraft var1, int var2, int var3, int var4, int var5, float var6, GuiControlDetailList var7);
    }

    public static interface IGuiDetailListColumn {
        public String getName();

        public int getWidth(int var1);
    }
}

