/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers.effects;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.effects.EntityEffect;
import org.orecruncher.dsurround.client.effects.IEntityEffectFactory;
import org.orecruncher.dsurround.client.effects.IEntityEffectFactoryFilter;
import org.orecruncher.dsurround.client.sound.ISoundInstance;
import org.orecruncher.dsurround.client.sound.SoundEffect;
import org.orecruncher.dsurround.registry.effect.EntityEffectInfo;
import org.orecruncher.dsurround.registry.item.IItemData;
import org.orecruncher.dsurround.registry.item.ItemUtils;
import org.orecruncher.lib.math.RayTrace;

@SideOnly(value=Side.CLIENT)
public class EntitySwingEffect
extends EntityEffect {
    protected int swingProgress = 0;
    protected boolean isSwinging = false;
    public static final IEntityEffectFactoryFilter DEFAULT_FILTER = (e, eei) -> eei.effects.contains("swing");

    @Override
    public String name() {
        return "Item Swing";
    }

    @Override
    public void update(@Nonnull Entity subject) {
        if (!ModOptions.sound.enableSwingSounds) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)subject;
        if (entity.func_184187_bx() instanceof EntityBoat) {
            return;
        }
        if (entity.field_184622_au != null && entity.field_110158_av > this.swingProgress) {
            RayTraceResult whatImHitting;
            ItemStack currentItem;
            IItemData data;
            SoundEffect soundEffect;
            if (!(this.isSwinging || (soundEffect = (data = ItemUtils.getItemData((currentItem = entity.func_184586_b(entity.field_184622_au)).func_77973_b())).getSwingSound(currentItem)) == null || (whatImHitting = RayTrace.trace((EntityLivingBase)entity)) != null && whatImHitting.field_72313_a == RayTraceResult.Type.BLOCK)) {
                ISoundInstance snd = this.getState().createSound(soundEffect, (Entity)entity);
                this.getState().playSound(snd);
            }
            this.isSwinging = true;
            this.swingProgress = entity.field_110158_av;
        } else {
            this.isSwinging = false;
            this.swingProgress = entity.field_110158_av;
        }
    }

    public static class Factory
    implements IEntityEffectFactory {
        @Override
        public List<EntityEffect> create(@Nonnull Entity entity, @Nonnull EntityEffectInfo eei) {
            return ImmutableList.of((Object)new EntitySwingEffect());
        }
    }
}

