/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.ambientsounds;

import com.creativemd.ambientsounds.AmbientCondition;
import com.creativemd.ambientsounds.AmbientEngine;
import com.creativemd.ambientsounds.AmbientEnviroment;
import com.creativemd.ambientsounds.AmbientRegion;
import com.creativemd.ambientsounds.AmbientSelection;
import com.creativemd.creativecore.common.config.api.CreativeConfig;
import com.google.gson.annotations.SerializedName;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class AmbientDimension {
    @CreativeConfig.DecimalRange(min=0.0, max=1.0)
    public transient double volumeSetting = 1.0;
    public String name;
    @SerializedName(value="disable-all")
    public boolean disableAll = false;
    @SerializedName(value="biome-selector")
    public AmbientCondition biomeSelector;
    public AmbientRegion[] regions;
    public Boolean night;
    public Boolean rain;
    public Boolean storm;
    public Integer id;
    @SerializedName(value="dimension-ids")
    public int[] dimensionIds;
    @SerializedName(value="dimension-names")
    public String[] dimensionNames;
    @SerializedName(value="bad-dimension-ids")
    public int[] badDimensionIds;
    @SerializedName(value="bad-dimension-names")
    public String[] badDimensionNames;
    @SerializedName(value="average-height")
    public Integer averageHeight;

    public void init(AmbientEngine engine) {
        int i;
        if (this.biomeSelector != null) {
            this.biomeSelector.init(engine);
        }
        if (this.badDimensionNames != null) {
            for (i = 0; i < this.badDimensionNames.length; ++i) {
                this.badDimensionNames[i] = ".*" + this.badDimensionNames[i].toLowerCase().replace("*", ".*").replace("?", "\\?") + ".*";
            }
        }
        if (this.dimensionNames != null) {
            for (i = 0; i < this.dimensionNames.length; ++i) {
                this.dimensionNames[i] = ".*" + this.dimensionNames[i].toLowerCase().replace("*", ".*").replace("?", "\\?") + ".*";
            }
        }
    }

    public boolean is(World world) {
        int j;
        if (this.badDimensionIds != null && ArrayUtils.contains((int[])this.badDimensionIds, (int)world.field_73011_w.getDimension())) {
            return false;
        }
        String dimensionTypeName = world.field_73011_w.func_186058_p().func_186065_b();
        if (this.badDimensionNames != null) {
            for (j = 0; j < this.badDimensionNames.length; ++j) {
                if (!dimensionTypeName.matches(this.badDimensionNames[j])) continue;
                return false;
            }
        }
        if (this.id != null && world.field_73011_w.getDimension() == this.id.intValue()) {
            return true;
        }
        if (this.dimensionIds != null && ArrayUtils.contains((int[])this.dimensionIds, (int)world.field_73011_w.getDimension())) {
            return true;
        }
        if (this.dimensionNames != null) {
            for (j = 0; j < this.dimensionNames.length; ++j) {
                if (!dimensionTypeName.matches(this.dimensionNames[j])) continue;
                return true;
            }
        }
        return this.id == null && this.dimensionIds == null && this.dimensionNames == null;
    }

    public void manipulateEnviroment(AmbientEnviroment env) {
        env.soundsDisabled = this.disableAll;
        if (this.night != null) {
            env.night = this.night;
        }
        if (this.rain != null) {
            env.raining = this.rain;
        }
        if (this.storm != null) {
            env.thundering = this.storm;
        }
        if (this.biomeSelector != null) {
            AmbientSelection selection = this.biomeSelector.value(env);
            env.biomeVolume = selection != null ? selection.getEntireVolume() : 0.0;
        }
        if (this.averageHeight != null) {
            env.setHeight(new AmbientEnviroment.TerrainHeight(this.averageHeight.intValue(), this.averageHeight, this.averageHeight));
        }
    }

    public String toString() {
        return this.name;
    }
}

