#version 120


/*
 _______ _________ _______  _______  _ 
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _ 
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the LICENSE.txt contained in the root directory of this shaderpack!

*/


#include "Common.inc"

////////////////////////////////////////////////////ADJUSTABLE VARIABLES/////////////////////////////////////////////////////////


#define WAVE_HEIGHT 0.75f

#define WATER_PARALLAX

#define RAIN_SPLASH_EFFECT // Rain ripples/splashes on water and wet blocks.


///////////////////////////////////////////////////END OF ADJUSTABLE VARIABLES///////////////////////////////////////////////////



uniform sampler2D texture;
uniform sampler2D specular;
uniform sampler2D normals;
uniform sampler2D noisetex;
uniform sampler2D gaux1;
uniform sampler2D gaux2;
uniform sampler2D gaux3;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;

uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;

uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;

uniform float frameTimeCounter;
uniform int worldTime;
uniform int frameCounter;

uniform float rainStrength;

varying vec3 normal;
varying vec3 globalNormal;
varying vec3 tangent;
varying vec3 binormal;
varying vec3 viewVector;

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;
varying vec3 worldPosition;
varying vec4 vertexPos;
varying float distance;

varying float iswater;
varying float isice;
varying float isStainedGlass;

#define ANIMATION_SPEED 1.0f


/* DRAWBUFFERS:02345 */



#define FRAME_TIME frameTimeCounter * ANIMATION_SPEED

vec4 cubic(float x)
{
    float x2 = x * x;
    float x3 = x2 * x;
    vec4 w;
    w.x =   -x3 + 3*x2 - 3*x + 1;
    w.y =  3*x3 - 6*x2       + 4;
    w.z = -3*x3 + 3*x2 + 3*x + 1;
    w.w =  x3;
    return w / 6.f;
}

vec4 BicubicTexture(in sampler2D tex, in vec2 coord)
{
	int resolution = 64;

	coord *= resolution;

	float fx = fract(coord.x);
    float fy = fract(coord.y);
    coord.x -= fx;
    coord.y -= fy;

    vec4 xcubic = cubic(fx);
    vec4 ycubic = cubic(fy);

    vec4 c = vec4(coord.x - 0.5, coord.x + 1.5, coord.y - 0.5, coord.y + 1.5);
    vec4 s = vec4(xcubic.x + xcubic.y, xcubic.z + xcubic.w, ycubic.x + ycubic.y, ycubic.z + ycubic.w);
    vec4 offset = c + vec4(xcubic.y, xcubic.w, ycubic.y, ycubic.w) / s;

    vec4 sample0 = texture2D(tex, vec2(offset.x, offset.z) / resolution);
    vec4 sample1 = texture2D(tex, vec2(offset.y, offset.z) / resolution);
    vec4 sample2 = texture2D(tex, vec2(offset.x, offset.w) / resolution);
    vec4 sample3 = texture2D(tex, vec2(offset.y, offset.w) / resolution);

    float sx = s.x / (s.x + s.y);
    float sy = s.z / (s.z + s.w);

    return mix( mix(sample3, sample2, sx), mix(sample1, sample0, sx), sy);
}

vec4 textureSmooth(in sampler2D tex, in vec2 coord)
{
	vec2 res = vec2(64.0f, 64.0f);

	coord *= res;
	coord += 0.5f;

	vec2 whole = floor(coord);
	vec2 part  = fract(coord);

	part.x = part.x * part.x * (3.0f - 2.0f * part.x);
	part.y = part.y * part.y * (3.0f - 2.0f * part.y);
	// part.x = 1.0f - (cos(part.x * 3.1415f) * 0.5f + 0.5f);
	// part.y = 1.0f - (cos(part.y * 3.1415f) * 0.5f + 0.5f);

	coord = whole + part;

	coord -= 0.5f;
	coord /= res;

	return texture2D(tex, coord);
}

float Parabola(in float x, in float k)
{
	x / 2.0f;
	return pow(4.0f * x * (1.0f - x), k);
}

float AlmostIdentity(in float x, in float m, in float n)
{
	if (x > m) return x;

	float a = 2.0f * n - m;
	float b = 2.0f * m - 3.0f * n;
	float t = x / m;

	return (a * t + b) * t * t + n;
}

float GetWaves(vec3 position, in float scale) {
  float speed = 0.9f;

  speed = mix(speed, 0.0f, isice);

  vec2 p = position.xz / 20.0f;

  p.xy -= position.y / 20.0f;

  p.x = -p.x;

  p.x += (FRAME_TIME / 40.0f) * speed;
  p.y -= (FRAME_TIME / 40.0f) * speed;

  float weight = 1.0f;
  float weights = weight;

  float allwaves = 0.0f;

  float wave = textureSmooth(noisetex, (p * vec2(2.0f, 1.2f))  + vec2(0.0f,  p.x * 2.1f) ).x; 			p /= 2.1f; 	/*p *= pow(2.0f, 1.0f);*/ 	p.y -= (FRAME_TIME / 20.0f) * speed; p.x -= (FRAME_TIME / 30.0f) * speed;
  allwaves += wave;

  weight = 4.1f;
  weights += weight;
      wave = textureSmooth(noisetex, (p * vec2(2.0f, 1.4f))  + vec2(0.0f,  -p.x * 2.1f) ).x;	p /= 1.5f;/*p *= pow(2.0f, 2.0f);*/ 	p.x += (FRAME_TIME / 20.0f) * speed;
      wave *= weight;
  allwaves += wave;

  weight = 17.25f;
  weights += weight;
      wave = (textureSmooth(noisetex, (p * vec2(1.0f, 0.75f))  + vec2(0.0f,  p.x * 1.1f) ).x);		p /= 1.5f; 	p.x -= (FRAME_TIME / 55.0f) * speed;
      wave *= weight;
  allwaves += wave;

  weight = 15.25f;
  weights += weight;
      wave = (textureSmooth(noisetex, (p * vec2(1.0f, 0.75f))  + vec2(0.0f,  -p.x * 1.7f) ).x);		p /= 1.9f; 	p.x += (FRAME_TIME / 155.0f) * speed;
      wave *= weight;
  allwaves += wave;

  weight = 29.25f;
  weights += weight;
      wave = abs(textureSmooth(noisetex, (p * vec2(1.0f, 0.8f))  + vec2(0.0f,  -p.x * 1.7f) ).x * 2.0f - 1.0f);		p /= 2.0f; 	p.x += (FRAME_TIME / 155.0f) * speed;
      wave = 1.0f - AlmostIdentity(wave, 0.2f, 0.1f);
      wave *= weight;
  allwaves += wave;

  weight = 15.25f;
  weights += weight;
      wave = abs(textureSmooth(noisetex, (p * vec2(1.0f, 0.8f))  + vec2(0.0f,  p.x * 1.7f) ).x * 2.0f - 1.0f);
      wave = 1.0f - AlmostIdentity(wave, 0.2f, 0.1f);
      wave *= weight;
  allwaves += wave;

  allwaves /= weights;

  return allwaves;
}

vec3 GetWaterParallaxCoord(in vec3 position, in vec3 viewVector)
{
	vec3 parallaxCoord = position.xyz;

	vec3 stepSize = vec3(0.6f * WAVE_HEIGHT, 0.6f * WAVE_HEIGHT, 0.6f);

	float waveHeight = GetWaves(position, 1.0f);

		vec3 pCoord = vec3(0.0f, 0.0f, 1.0f);

		vec3 step = viewVector * stepSize;
		float distAngleWeight = ((distance * 0.2f) * (2.1f - viewVector.z)) / 2.0f;
		distAngleWeight = 1.0f;
		step *= distAngleWeight;

		float sampleHeight = waveHeight;

		for (int i = 0; sampleHeight < pCoord.z && i < 120; ++i)
		{
			pCoord.xy = mix(pCoord.xy, pCoord.xy + step.xy, clamp((pCoord.z - sampleHeight) / (stepSize.z * 0.2f * distAngleWeight / (-viewVector.z + 0.05f)), 0.0f, 1.0f));
			pCoord.z += step.z;
			//pCoord += step;
			sampleHeight = GetWaves(position + vec3(pCoord.x, 0.0f, pCoord.y), 1.0f);
		}

	parallaxCoord = position.xyz + vec3(pCoord.x, 0.0f, pCoord.y);

	return parallaxCoord;
}

vec3 GetWavesNormal(vec3 position, in float scale, in mat3 tbnMatrix) {

	vec4 modelView = (gl_ModelViewMatrix * vertexPos);

	vec3 viewVector = normalize(tbnMatrix * modelView.xyz);

		 viewVector = normalize(viewVector);


	#ifdef WATER_PARALLAX
	position = GetWaterParallaxCoord(position, viewVector);
	#endif


	const float sampleDistance = 13.0f;

	position -= vec3(0.005f, 0.0f, 0.005f) * sampleDistance;

	float wavesCenter = GetWaves(position, scale);
	float wavesLeft = GetWaves(position + vec3(0.01f * sampleDistance, 0.0f, 0.0f), scale);
	float wavesUp   = GetWaves(position + vec3(0.0f, 0.0f, 0.01f * sampleDistance), scale);

	vec3 wavesNormal;
		 wavesNormal.r = wavesCenter - wavesLeft;
		 wavesNormal.g = wavesCenter - wavesUp;

		 wavesNormal.r *= 20.0f * WAVE_HEIGHT / sampleDistance;
		 wavesNormal.g *= 20.0f * WAVE_HEIGHT / sampleDistance;


	//wavesNormal.rg *= saturate(1.0 - length(position.xyz - cameraPosition.xyz) / 20.0);


		//  wavesNormal.b = sqrt(1.0f - wavesNormal.r * wavesNormal.r - wavesNormal.g * wavesNormal.g);
     wavesNormal.b = 1.0;
		 wavesNormal.rgb = normalize(wavesNormal.rgb);


		 //float upAmount = dot(fwidth(position.xyz), vec3(1.0));
		 //float upAmount = 1.0 - saturate(dot(-viewVector, wavesNormal));
		 //upAmount = upAmount / (upAmount + 1.0);

		 //wavesNormal = normalize(wavesNormal + vec3(0.0, -1.0, 0.0) * upAmount * 1.0);



	return wavesNormal.rgb;
}


float CurveBlockLightTorch(float blockLight)
{
	float falloff = 10.0;

	blockLight = exp(-(1.0 - blockLight) * falloff);
	blockLight = max(0.0, blockLight - exp(-falloff));

	return blockLight;
}


vec3 Get3DNoise(in vec3 pos)
{
	pos.z += 0.0f;
	vec3 p = floor(pos);
	vec3 f = fract(pos);
		 f = f * f * (3.0f - 2.0f * f);

	vec2 uv =  (p.xy + p.z * vec2(17.0f, 37.0f)) + f.xy;
	vec2 uv2 = (p.xy + (p.z + 1.0f) * vec2(17.0f, 37.0f)) + f.xy;
	vec2 coord =  (uv  + 0.5f) / 64.0f;
	vec2 coord2 = (uv2 + 0.5f) / 64.0f;
	vec3 xy1 = texture2D(noisetex, coord).xyz;
	vec3 xy2 = texture2D(noisetex, coord2).xyz;
	return mix(xy1, xy2, vec3(f.z));
}

vec3 Get3DNoiseNormal(in vec3 pos)
{
	float center = Get3DNoise(pos + vec3( 0.0f, 0.0f, 0.0f)).x * 2.0f - 1.0f;
	float left 	 = Get3DNoise(pos + vec3( 0.1f, 0.0f, 0.0f)).x * 2.0f - 1.0f;
	float up     = Get3DNoise(pos + vec3( 0.0f, 0.1f, 0.0f)).x * 2.0f - 1.0f;

	vec3 noiseNormal;
		 noiseNormal.x = center - left;
		 noiseNormal.y = center - up;

		 noiseNormal.x *= 0.2f;
		 noiseNormal.y *= 0.2f;

		 noiseNormal.b = sqrt(1.0f - noiseNormal.x * noiseNormal.x - noiseNormal.g * noiseNormal.g);
		 noiseNormal.b = 0.0f;

	return noiseNormal.xyz;
}

float GetModulatedRainSpecular(in vec3 pos)
{
	//pos.y += frameTimeCounter * 3.0f;
	pos.xz *= 1.0f;
	pos.y *= 0.2f;

	// pos.y += Get3DNoise(pos.xyz * vec3(1.0f, 0.0f, 1.0f)).x * 2.0f;

	vec3 p = pos;

	float n = Get3DNoise(p).y;
		  n += Get3DNoise(p / 2.0f).x * 2.0f;
		  n += Get3DNoise(p / 4.0f).x * 4.0f;

		  n /= 7.0f;


	n = saturate(n * 0.8 + 0.5) * 0.97;


	return n;
}


vec3 GetRainAnimationTex(sampler2D tex, vec2 uv, float wet)
{
	//float frame = mod(floor(float(frameCounter) * 1.0), 60.0);
	// frame = 0.0;

	float frame = mod(floor(frameTimeCounter * 60.0), 60.0);
	vec2 coord = vec2(uv.x, mod(uv.y / 60.0, 1.0) - frame / 60.0);

	vec3 n = texture2D(tex, coord).rgb * 2.0 - 1.0;
	n.y *= -1.0;

	n.xy = pow(abs(n.xy) * 1.0, vec2(2.0 - wet * wet * wet * 1.2)) * sign(n.xy);
	// n.xy = pow(abs(n.xy) * 1.0, vec2(1.0)) * sign(n.xy);

	return n;
}

vec3 GetRainNormal(in vec3 pos, float wet)
{
	// pos.xz *= 30.0;

	// pos.y += wet * 12.0;


	// pos.y += -pos.x * 0.15;
	// pos.y += frameTimeCounter * 20.0;


	// vec3 n = Get3DNoiseNormal(pos.xyz);
	// n.xy += Get3DNoiseNormal(pos.xzy * 2.0).xy * 0.5;
	// n.xy += Get3DNoiseNormal((pos.xzy + pos.x) * 0.25 + vec3(-frameTimeCounter * 2.0, 0.0, 0.0)).xy * 1.5;

	// // n.xy *= 0.035;
	// n.xy *= 0.5;



	// pos.xz *= 0.2;

	// vec3 n = vec3(0.0, 0.0, 1.0);
	// //n.xy += sin(texture2D(noisetex, pos.xz).xy * 20.0 + frameTimeCounter * 20.0);

	// pos.y += frameTimeCounter * 0.02;
	// n.xy += sin(Get3DNoise(pos.xyz * 64.0).xy * 12.0 + frameTimeCounter * 30.0);
	// pos *= 1.5;
	// n.xy += sin(Get3DNoise(pos.xyz * 64.0 + 0.5).xy * 12.0 + frameTimeCounter * 49.0);
	// // pos.xz *= 3.1;
	// // n.xy += sin(texture2D(noisetex, pos.xz).xy * 8.0 + frameTimeCounter * 30.0);

	// n.xy *= 0.02;

	// pos *= 0.5;

	// float rC = RainRipples(pos.xz);
	// float rR = RainRipples(pos.xz + vec2(0.01, 0.0) * 0.2);
	// float rU = RainRipples(pos.xz + vec2(0.0, 0.01) * 0.2);

	// vec3 n = vec3(0.0, 0.0, 1.0);

	// n.x = rC - rR;
	// n.y = rC - rU;

	// n.xy *= 1.0;

	// n = normalize(n);

	//float frame = mod(floor(frameTimeCounter * 60.0), 1.0);







	// pos.xyz *= 0.5;

	// vec3 n = GetRainAnimationTex(pos.xz, wet);
	// vec3 nR = GetRainAnimationTex(pos.xz + vec2(1.0, 0.0) / 128.0, wet);
	// vec3 nU = GetRainAnimationTex(pos.xz + vec2(0.0, 1.0) / 128.0, wet);
	// vec3 nUR = GetRainAnimationTex(pos.xz + vec2(1.0, 1.0) / 128.0, wet);

	// vec2 fractCoord = fract(pos.xz * 128.0);

	// vec3 lerpX = mix(n, nR, fractCoord.x);
	// vec3 lerpX2 = mix(nU, nUR, fractCoord.x);
	// vec3 lerpY = mix(lerpX, lerpX2, fractCoord.y);

	// // n.xy *= 0.5;
	// // n = lerpY;
	// // n = normalize(lerpY);

	// n.xy *= 2.0;


	// float lod = dot(abs(fwidth(pos.xyz)), vec3(1.0));

	// n.xy *= 1.0 / (1.0 + lod * 10.0);

	// n.xy *= rainStrength;


	pos.xyz *= 0.5;


	vec3 n1 = GetRainAnimationTex(gaux1, pos.xz, wet);
	vec3 n2 = GetRainAnimationTex(gaux2, pos.xz, wet);
	vec3 n3 = GetRainAnimationTex(gaux3, pos.xz, wet);

	pos.x -= frameTimeCounter * 1.5;
	float downfall = texture2D(noisetex, pos.xz * 0.0025).x;
	downfall = saturate(downfall * 1.5 - 0.25);


	vec3 n = n1 * 2.0;
	n += n2 * saturate(downfall * 2.0) * 2.0;
	n += n3 * saturate(downfall * 2.0 - 1.0) * 2.0;
	// n = n3 * 3.0;

	n *= 0.2;

	float lod = dot(abs(fwidth(pos.xyz)), vec3(1.0));

	n.xy *= 1.0 / (1.0 + lod * 5.0);

	n.xy /= wet + 0.1;
	// n.x = downfall;

	wet = saturate(wet * 1.0 + downfall * (1.0 - wet) * 0.5);
	// wet = downfall * 0.2 + 0.8;

	n.xy *= rainStrength;

	return n;
}

void main() {

	vec4 tex = texture2D(texture, texcoord.st);
		 //tex.a = 0.85f;

	vec4 transparentAlbedo = tex;

	float zero = 1.0f;
	float transx = 0.0f;
	float transy = 0.0f;

	//float iswater = 0.0f;

	float texblock = 0.0625f;

	bool backfacing = false;

	if (viewVector.z > 0.0f) {
		backfacing = true;
	} else {
		backfacing = false;
	}


	if (iswater > 0.5 || isice > 0.5 || isStainedGlass > 0.5) 
	{
		tex = vec4(0.0, 0.0, 0.0f, 0.2);
	}

	//store lightmap in auxilliary texture. r = torch light. g = lightning. b = sky light.

	//Separate lightmap types
	vec4 lightmap = vec4(0.0f, 0.0f, 0.0f, 1.0f);
	lightmap.r = clamp((lmcoord.s * 33.05f / 32.0f) - 1.05f / 32.0f, 0.0f, 1.0f);
	lightmap.b = clamp((lmcoord.t * 33.05f / 32.0f) - 1.05f / 32.0f, 0.0f, 1.0f);

	//lightmap.b = pow(lightmap.b, 1.0f);
	//lightmap.r = pow(lightmap.r, 3.0f);







	float matID = 1.0f;

	if (iswater > 0.5f)
	{
			matID = 6.0f;
	}

	if (isice > 0.5)
	{
		matID = 8;
	}

	if (isStainedGlass > 0.5)
	{
		matID = 7.0;
	}


	matID += 0.1f;

  // gl_FragData[0] = vec4(tex.rgb, 0.2);

	mat3 tbnMatrix = mat3 (tangent.x, binormal.x, normal.x,
							tangent.y, binormal.y, normal.y,
					     	tangent.z, binormal.z, normal.z);




	vec3 wavesNormal = GetWavesNormal(worldPosition, 1.0f, tbnMatrix);
	//vec3 wavesNormal = vec3(0.0f, 0.0f, 1.0f);
	#ifdef RAIN_SPLASH_EFFECT
		wavesNormal = normalize(wavesNormal + GetRainNormal(worldPosition.xyz, 1.0) * 1.0 * vec3(1.0, 1.0, 0.0));
	#endif

	vec3 waterNormal = wavesNormal * tbnMatrix;
	vec3 texNormal = texture2D(normals, texcoord.st).rgb * 2.0f - 1.0f;
		 texNormal = texNormal * tbnMatrix;


	waterNormal = mix(waterNormal, texNormal, isice + isStainedGlass);

	lightmap.r = CurveBlockLightTorch(lightmap.r);
	lightmap.r = pow(lightmap.r, 0.25);

	gl_FragData[0] = vec4(tex.rgb, tex.a);
	//gl_FragData[1] = vec4(lightmap.rb, 0.0, 1.0);
	gl_FragData[1] = vec4(EncodeNormal(texNormal), 0.0, tex.a);







	//lightmap.r = 0.0;

	vec2 data3 = vec2(0.0, 0.0);
	if (isice > 0.5 || iswater > 0.5 || isStainedGlass > 0.5)
		data3 = vec2(lightmap.r, lightmap.b);

	gl_FragData[2] = vec4(data3, (matID) / 255.0, tex.a * 5.0);

	gl_FragData[3] = vec4(EncodeNormal(waterNormal.xyz).xy, 0.0, 1.0f);
	gl_FragData[4] = vec4(transparentAlbedo);



	//gl_FragData[7] = vec4(globalNormal * 0.5f + 0.5f, 1.0);
}
